package com.mcsnowflake.worktimer.ui.views.dashboard

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.imePadding
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import com.mcsnowflake.worktimer.ui.components.appbar.MenuAppBar
import com.mcsnowflake.worktimer.ui.components.banners.Banners
import com.mcsnowflake.worktimer.ui.components.buttons.ActionButtons
import com.mcsnowflake.worktimer.ui.components.timer.Timer
import org.koin.androidx.compose.koinViewModel

const val DASHBOARD = "dashboard"

// @Preview
@Composable
fun Dashboard(
    modifier: Modifier = Modifier,
    navigateTo: (String) -> Unit = {},
    dashBoardViewModel: DashBoardViewModel = koinViewModel()
) = Scaffold(
    modifier = modifier.imePadding(),
    topBar = {
        val showStatsIcon by dashBoardViewModel.showStatsIcon.collectAsState()
        MenuAppBar("WorkTimer", navigateTo, showStatsIcon)
    }) { innerPadding ->

    Column(
        Modifier
            .padding(innerPadding)
            .fillMaxSize(),
        verticalArrangement = Arrangement.Bottom,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Banners()
        Spacer(Modifier.weight(1f))
        Header(state = dashBoardViewModel.timerState)
        Spacer(Modifier.weight(1f))
        Timer(timerState = dashBoardViewModel.timerState)
        Spacer(Modifier.weight(1f))
        ActionButtons(dashBoardViewModel = dashBoardViewModel)
        Spacer(Modifier.weight(1f))

    }
}

