package com.mcsnowflake.worktimer.ui.views.about.content

import androidx.compose.foundation.Image
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.DefaultAlpha
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.ui.views.about.Scrollable

@Composable
fun ColumnScope.Greeter(
    headerWeight: Float,
    textWeight: Float
) {
    Column(
        modifier = Modifier.weight(headerWeight + 1f),
        horizontalAlignment = Alignment.CenterHorizontally,
        verticalArrangement = Arrangement.spacedBy(8.dp, Alignment.CenterVertically)
    ) {
        Image(
            modifier = Modifier.weight(1f),
            painter = painterResource(id = R.drawable.ic_logo),
            contentDescription = stringResource(id = R.string.application_logo_description),
            alpha = if (isSystemInDarkTheme()) 0.8f else DefaultAlpha
        )
        Text(text = "WorkTimer", style = MaterialTheme.typography.headlineMedium, color = MaterialTheme.colorScheme.primary, fontFamily = FontFamily.Serif)
    }

    Scrollable(textWeight) {
        Text(stringResource(id = R.string.greeter_explanation_1))
        Text(stringResource(id = R.string.greeter_explanation_2))
        Text(stringResource(id = R.string.greeter_explanation_3))
    }
}
