package com.mcsnowflake.worktimer.ui.components.appbar

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.MoreVert
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.ui.dialogs.BugReportDialog
import com.mcsnowflake.worktimer.ui.views.about.ABOUT_SCREEN
import com.mcsnowflake.worktimer.ui.views.about.showAppBar
import com.mcsnowflake.worktimer.ui.views.credits.CREDITS

@Preview(showBackground = true, backgroundColor = 0xFF00FF00)
@Composable
fun Menu(
    navigate: (String) -> Unit = {}
) {
    val expandMenu = remember { mutableStateOf(false) }
    val showBugReportDialog = remember { mutableStateOf(false) }

    Box(
        Modifier.wrapContentSize(Alignment.TopEnd)
    ) {
        IconButton({ expandMenu.value = true }) { Icon(Icons.Filled.MoreVert, stringResource(id = R.string.menu_content_description)) }
    }

    DropdownMenu(
        expanded = expandMenu.value,
        onDismissRequest = { expandMenu.value = false },
    ) {
        DropdownMenuItem(
            text = { Text(stringResource(id = R.string.about_the_app)) },
            onClick = {
                expandMenu.value = false
                navigate(ABOUT_SCREEN.showAppBar(true))
            })
        HorizontalDivider()
        DropdownMenuItem(
            {
                Text(stringResource(id = R.string.credits))
            },
            onClick = {
                expandMenu.value = false
                navigate(CREDITS)
            })
        HorizontalDivider()
        DropdownMenuItem(
            {
                Text(stringResource(id = R.string.report_a_bug))
            },
            onClick = {
                expandMenu.value = false
                showBugReportDialog.value = true
            })
    }

    BugReportDialog(showBugReportDialog)
}
