@file:OptIn(ExperimentalTime::class)

package com.mcsnowflake.worktimer.state

import kotlin.time.ExperimentalTime
import kotlinx.serialization.Serializable

@Serializable
sealed interface TimerState {

    @Serializable
    sealed interface Session : TimerState {
        val session: SessionData

        @Serializable
        data class Running(
            override val session: SessionData
        ) : Session

        @Serializable
        data class Finished(
            override val session: SessionData
        ) : Session
    }

    @Serializable
    object Stopped : TimerState {
        override fun toString(): String = javaClass.simpleName
    }
}
