package com.mcsnowflake.worktimer.notifications

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.mcsnowflake.worktimer.state.TimerEvent
import kotlinx.coroutines.flow.MutableSharedFlow
import org.koin.core.component.KoinComponent
import org.koin.core.component.get

/**
 * Receives timer action broadcasts (from notifications/UI) and forwards them
 * to the TimerStateMachine, replacing the old foreground service command path.
 */
class ActionReceiver : BroadcastReceiver(), KoinComponent {
    override fun onReceive(context: Context, intent: Intent?) {
        Log.d("ActionReceiver", "Received action: ${intent?.action}")
        intent?.action?.let { action ->
            runCatching { NotificationAction.valueOf(action) }.getOrNull()
        }?.also { action ->
            val events: MutableSharedFlow<TimerEvent> = get()
            events.tryEmit(action.event)
        }
    }
}
