package com.mcsnowflake.worktimer.alarms

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.mcsnowflake.worktimer.alarms.AlarmHandler.Companion.AlarmType
import com.mcsnowflake.worktimer.alarms.AlarmHandler.Companion.AlarmType.HYDRATION_ALARM
import com.mcsnowflake.worktimer.alarms.AlarmHandler.Companion.AlarmType.TIMER_ALARM
import com.mcsnowflake.worktimer.notifications.NotificationHandler
import com.mcsnowflake.worktimer.state.TimerEvent
import kotlinx.coroutines.flow.MutableSharedFlow
import org.koin.core.component.KoinComponent
import org.koin.core.component.get

/**
 * Receives timer end alarms and forwards them to the TimerStateMachine.
 */
class AlarmReceiver : BroadcastReceiver(), KoinComponent {
    override fun onReceive(context: Context, intent: Intent?) {
        Log.d("AlarmReceiver", "Alarm fired: ${intent?.action}")
        when (intent?.action?.let { AlarmType.valueOf(it) }) {
            HYDRATION_ALARM -> get<NotificationHandler>().sendHydrationNotification()
            TIMER_ALARM -> get<MutableSharedFlow<TimerEvent>>().tryEmit(TimerEvent.FINISH)
            null -> Log.w("AlarmReceiver", "Alarm action was null")
        }
    }
}
