@file:OptIn(ExperimentalMaterial3Api::class)

package com.mcsnowflake.worktimer.ui.views.about.content

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.rounded.Settings
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.ui.views.about.Header
import com.mcsnowflake.worktimer.ui.views.about.Scrollable

@Composable
fun ColumnScope.Manual(
    headerWeight: Float,
    textWeight: Float
) {
    Header(
        stringResource(id = R.string.customizable_header),
        Icons.Rounded.Settings,
        Modifier.weight(headerWeight)
    )
    Scrollable(textWeight) {
        Text(stringResource(id = R.string.manual_explanation))
        InputFieldData.entries.forEachIndexed { index, item ->
            DemoCard(item, if (index % 2 == 0) Alignment.End else Alignment.Start)
        }
    }
}

@Preview
@Composable
fun DemoCard(
    data: InputFieldData = InputFieldData.WORK_SESSION,
    alignment: Alignment.Horizontal = Alignment.End
) = Card(
    modifier = Modifier.fillMaxWidth(),
    colors = CardDefaults.cardColors(
        containerColor = data.color()
    )
) {
    Column(
        modifier = Modifier.padding(16.dp),
        horizontalAlignment = alignment,
        verticalArrangement = Arrangement.spacedBy(8.dp)
    ) {
        Text(
            modifier = Modifier.padding(horizontal = 32.dp),
            text = stringResource(id = data.label),
            style = MaterialTheme.typography.headlineMedium
        )
        Text(
            text = stringResource(id = data.text),
            style = MaterialTheme.typography.bodyMedium
        )
    }
}

enum class InputFieldData(val label: Int, val color: @Composable () -> Color, val text: Int) {
    WORK_SESSION(
        R.string.work_session_manual_label,
        { MaterialTheme.colorScheme.primaryContainer },
        R.string.work_session_manual_explanation
    ),
    SHORT_BREAK(
        R.string.short_break_manual_label,
        { MaterialTheme.colorScheme.tertiaryContainer },
        R.string.short_break_manual_explanation
    ),
    BREAK_RATIO(
        R.string.break_ratio_manual_label,
        { MaterialTheme.colorScheme.primaryContainer },
        R.string.break_ratio_manual_explanation
    ),
    LONG_BREAK(
        R.string.long_break_manual_label,
        { MaterialTheme.colorScheme.tertiaryContainer },
        R.string.long_break_manual_explanation
    );

    fun next(): InputFieldData {
        return when (this) {
            WORK_SESSION -> SHORT_BREAK
            SHORT_BREAK -> LONG_BREAK
            LONG_BREAK -> BREAK_RATIO
            BREAK_RATIO -> WORK_SESSION
        }
    }
}
