package com.mcsnowflake.worktimer.ui.views.about

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp

@Composable
fun SpecialButton(
    modifier: Modifier,
    text: String,
    onClick: () -> Unit
) = OutlinedButton(
    modifier = modifier,
    onClick = onClick,
    contentPadding = PaddingValues(
        start = 8.dp,
        top = 0.dp,
        end = 8.dp,
        bottom = 0.dp
    )
) {
    Text(text, Modifier.padding(bottom = 2.dp, start = 4.dp))
}
