package com.mcsnowflake.worktimer.ui.views.about

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.HorizontalDivider
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.BiasAlignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp

@Composable
fun ColumnScope.Scrollable(
    weight: Float,
    content: @Composable ColumnScope.() -> Unit
) {
    val scrollState = rememberScrollState()
    if (scrollState.value > 0) HorizontalDivider()
    Column(
        modifier = Modifier
            .weight(weight)
            .verticalScroll(scrollState),
        verticalArrangement = Arrangement.spacedBy(16.dp, BiasAlignment.Vertical(-0.4f)),
        horizontalAlignment = Alignment.CenterHorizontally,
        content = content
    )
    if (scrollState.value < scrollState.maxValue) HorizontalDivider()
}
