package com.mcsnowflake.worktimer.ui.views.about

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.BottomAppBar
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R

@Preview
@Composable
fun BottomButtons(
    page: Page = Page.FEATURES,
    onNext: () -> Unit = {},
    onClose: () -> Unit = {},

    ) = BottomAppBar(
    containerColor = MaterialTheme.colorScheme.surface
) {
    Row(
        modifier = Modifier.fillMaxWidth().padding(horizontal = 32.dp),
        horizontalArrangement = Arrangement.spacedBy(16.dp, Alignment.CenterHorizontally)
    ) {
        SpecialButton(
            modifier = Modifier.weight(0.4f),
            text = if (page.isNotLastPage) stringResource(id = R.string.about_skip_introduction) else stringResource(id = R.string.about_close),
            onClick = onClose
        )
        if (page.isNotLastPage) {
            SpecialButton(
                modifier = Modifier.weight(0.4f),
                text = stringResource(id = page.nextPageLabel),
                onClick = onNext
            )
        }
    }
}
