package com.mcsnowflake.worktimer.ui.dialogs

import android.content.Intent
import android.provider.Settings
import android.util.Log
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import org.koin.compose.koinInject

@Preview(locale = "de")
@Preview(locale = "es")
@Preview(locale = "fr")
@Preview
@Composable
fun DndPermissionDialogInternal(
    isVisible: Boolean = true,
    onDismiss: () -> Unit = {}
) {
    val context = LocalContext.current
    if (isVisible) {
        AlertDialog(
            onDismissRequest = onDismiss,
            dismissButton = { Button(onDismiss) { Text(stringResource(id = R.string.dialog_cancel)) } },
            confirmButton = {
                Button({
                    onDismiss()
                    context.startActivity(Intent(Settings.ACTION_NOTIFICATION_POLICY_ACCESS_SETTINGS))
                }) { Text(stringResource(id = android.R.string.ok)) }
            },
            title = { Text(stringResource(id = R.string.dnd_permission_dialog_title)) },
            text = {
                Column(verticalArrangement = Arrangement.spacedBy(8.dp)) {
                    Text(
                        buildAnnotatedString {
                            append(stringResource(id = R.string.dnd_permission_dialog_description1_start))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.dnd_mode))
                            }
                            append(stringResource(id = R.string.dnd_permission_dialog_description1_end))
                        }
                    )
                    Text(
                        buildAnnotatedString {
                            append(stringResource(id = R.string.dnd_permission_dialog_description2_start))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = android.R.string.ok))
                            }
                            append(stringResource(id = R.string.dnd_permission_dialog_description2_middle))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.app_name))
                            }
                            append(stringResource(id = R.string.dnd_permission_dialog_description2_end))
                        }
                    )
                }
            }

        )
    }
}

@Composable
fun DndPermissionDialog(
    viewState: DndPermissionDialogViewState = koinInject()
) {
    val isVisible by viewState.isVisible.collectAsState(false)
    DndPermissionDialogInternal(isVisible, viewState::dismiss)
}

class DndPermissionDialogViewState {

    private val _isVisible = MutableStateFlow(false)
    val isVisible: StateFlow<Boolean> = _isVisible.asStateFlow()

    fun show() {
        Log.d("DndPermissionDialogViewModel", "should show")
        _isVisible.value = true
    }

    fun dismiss() {
        Log.d("DndPermissionDialogViewModel", "should not show")
        _isVisible.value = false
    }
}

