package com.mcsnowflake.worktimer.ui.components.banners

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.rounded.AlarmOff
import androidx.compose.material3.Icon
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.configuration.LateAlarmStatus
import com.mcsnowflake.worktimer.ui.dialogs.LateAlarmsDialogViewState
import org.koin.androidx.compose.koinViewModel
import org.koin.compose.koinInject

@Preview
@Composable
fun LateAlarmsBanner(
    lateAlarmsDialogViewState: LateAlarmsDialogViewState = koinInject(),
    bannersViewModel: BannersViewModel = koinViewModel()
) {

    val lateAlarmsRegistered by bannersViewModel.getLateAlarmsStatus().collectAsState(LateAlarmStatus.NO_LATE_ALARMS)

    AnimatedBanner(
        isVisible = lateAlarmsRegistered == LateAlarmStatus.LATE_ALARMS_REGISTERED.name,
        icon = { Icon(Icons.Rounded.AlarmOff, stringResource(id = R.string.late_alarms_banner_icon_description)) },
        text = stringResource(id = R.string.late_alarms_banner_text),
        actions = mapOf(
            stringResource(id = R.string.late_alarms_banner_action_read_more) to { lateAlarmsDialogViewState.show() },
            stringResource(id = R.string.late_alarms_banner_action_dismiss) to { bannersViewModel.setLateAlarmsDismissed() })
    )
}
