This document provides information for AI agents to understand the WorkTimer project and assist with development.

## Project Overview

WorkTimer is an Android application designed to help users manage their work and break intervals using the Pomodoro Technique. The app is built with modern Android development practices, utilizing Kotlin, Jetpack Compose, and Koin for dependency injection.

### Key Technologies

*   **Kotlin:** The primary programming language.
*   **Jetpack Compose:** Used for building the UI.
*   **Koin:** For dependency injection.
*   **Coroutines and Flows:** For asynchronous programming.
*   **DataStore:** For storing user preferences and application state.
*   **Robolectric and Kotest:** For unit testing.

### Architecture

The application follows a Model-View-ViewModel (MVVM) architecture. The core components are:

*   **State Management:** The application state is managed by a `TimerStateMachine`, which processes `TimerEvent`s and produces `TimerState`s. The state is persisted using `StateStore` and `DataStore`.
*   **Dependency Injection:** Koin is used to manage dependencies. The main dependencies are defined in the `KoinModule.kt` file.
*   **UI:** The UI is built entirely with Jetpack Compose. ViewModels provide data to the Composables.
*   **Notifications and Alarms:** The application uses `AlarmManager` and `NotificationManager` to schedule and display notifications for work sessions, breaks, and hydration reminders.

### Key Files

*   `app/build.gradle.kts`: Defines the project's dependencies and build configurations.
*   `app/src/main/kotlin/com/mcsnowflake/worktimer/KoinModule.kt`: The central location for dependency injection setup.
*   `app/src/main/kotlin/com/mcsnowflake/worktimer/state/TimerStateMachine.kt`: The core of the application's state management.
*   `app/src/main/kotlin/com/mcsnowflake/worktimer/MainActivity.kt`: The main entry point of the application.
*   `app/src/main/res/values/strings.xml`: The location of all string resources.

## Development Notes

*   When editing string resources in `strings.xml` files, apostrophes must be escaped with a backslash (\). For example, "Let's" should be written as "Let\'s".
