package com.liskovsoft.youtubeapi.app.potokennp2

import android.content.Context
import java.io.Closeable

/**
 * This interface was created to allow for multiple methods to generate poTokens in the future (e.g.
 * via WebView and via a local DOM implementation)
 */
internal interface PoTokenGenerator : Closeable {
    /**
     * Generates a poToken for the provided identifier, using the `integrityToken` and
     * `webPoSignalOutput` previously obtained in the initialization of [PoTokenWebView]. Can be
     * called multiple times.
     */
    fun generatePoToken(identifier: String): String

    /**
     * @return whether the `integrityToken` is expired, in which case all tokens generated by
     * [generatePoToken] will be invalid
     */
    fun isExpired(): Boolean

    interface Factory {
        /**
         * Initializes a [PoTokenGenerator] by loading the BotGuard VM, running it, and obtaining
         * an `integrityToken`. Can then be used multiple times to generate multiple poTokens with
         * [generatePoToken].
         *
         * @param context used e.g. to load the HTML asset or to instantiate a WebView
         */
        fun newPoTokenGenerator(context: Context): PoTokenGenerator
    }
}
