"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _native = require("./native");
var _types = require("./types");
class TurboLoggerStatic {
  logToFile = false;
  async configure(options = {}) {
    const {
      captureConsole = true,
      logToFile = true
    } = options;
    await (0, _native.configure)(options);
    this.logToFile = logToFile;
    if (captureConsole) {
      const c = {
        ...global.console
      };
      global.console.debug = (...args) => {
        this.log(_types.LogLevel.Debug, ...args);
        if (__DEV__) {
          c.debug(...args);
        }
      };
      global.console.log = (...args) => {
        this.log(_types.LogLevel.Info, ...args);
        if (__DEV__) {
          c.log(...args);
        }
      };
      global.console.info = (...args) => {
        this.log(_types.LogLevel.Info, ...args);
        if (__DEV__) {
          c.info(...args);
        }
      };
      global.console.warn = (...args) => {
        this.log(_types.LogLevel.Warning, ...args);
        if (__DEV__) {
          c.warn(...args);
        }
      };
      global.console.error = (...args) => {
        this.log(_types.LogLevel.Error, ...args);
        if (__DEV__) {
          c.error(...args);
        }
      };
    }
  }
  async deleteLogs() {
    return (0, _native.deleteLogFiles)();
  }
  async getLogPaths() {
    return (0, _native.getLogFilePaths)();
  }
  setLogToFile(enabled) {
    this.logToFile = enabled;
  }
  debug(...args) {
    this.log(_types.LogLevel.Debug, ...args);
  }
  info(...args) {
    this.log(_types.LogLevel.Info, ...args);
  }
  warn(...args) {
    this.log(_types.LogLevel.Warning, ...args);
  }
  error(...args) {
    this.log(_types.LogLevel.Error, ...args);
  }
  log(level, ...args) {
    if (this.logToFile) {
      (0, _native.write)(level, args);
    }
  }
}
const turboLogger = new TurboLoggerStatic();
var _default = exports.default = turboLogger;
//# sourceMappingURL=logger.js.map