/* @generated */
// prettier-ignore
if (Intl.NumberFormat && typeof Intl.NumberFormat.__addLocaleData === 'function') {
  Intl.NumberFormat.__addLocaleData({
  "data": {
    "currencies": {
      "AED": {
        "displayName": {
          "one": "UAE dirham",
          "other": "UAE dirhams"
        },
        "narrow": "AED",
        "symbol": "AED"
      },
      "AFN": {
        "displayName": {
          "one": "Afghan Afghani",
          "other": "Afghan Afghanis"
        },
        "narrow": "؋",
        "symbol": "AFN"
      },
      "ALL": {
        "displayName": {
          "one": "Albanian lek",
          "other": "Albanian leke"
        },
        "narrow": "ALL",
        "symbol": "ALL"
      },
      "AMD": {
        "displayName": {
          "one": "Armenian dram",
          "other": "Armenian drams"
        },
        "narrow": "֏",
        "symbol": "AMD"
      },
      "ANG": {
        "displayName": {
          "one": "Netherlands Antillean guilder",
          "other": "Netherlands Antillean guilders"
        },
        "narrow": "ANG",
        "symbol": "ANG"
      },
      "AOA": {
        "displayName": {
          "one": "Angolan kwanza",
          "other": "Angolan kwanzas"
        },
        "narrow": "Kz",
        "symbol": "AOA"
      },
      "ARS": {
        "displayName": {
          "one": "Argentine peso",
          "other": "Argentine pesos"
        },
        "narrow": "$",
        "symbol": "ARS"
      },
      "AUD": {
        "displayName": {
          "one": "Australian dollar",
          "other": "Australian dollars"
        },
        "narrow": "$",
        "symbol": "A$"
      },
      "AWG": {
        "displayName": {
          "other": "Aruban florin"
        },
        "narrow": "AWG",
        "symbol": "AWG"
      },
      "AZN": {
        "displayName": {
          "one": "Azerbaijani manat",
          "other": "Azerbaijani manats"
        },
        "narrow": "₼",
        "symbol": "AZN"
      },
      "BAM": {
        "displayName": {
          "one": "Bosnia-Herzegovina convertible mark",
          "other": "Bosnia-Herzegovina convertible marks"
        },
        "narrow": "KM",
        "symbol": "BAM"
      },
      "BBD": {
        "displayName": {
          "one": "Barbadian dollar",
          "other": "Barbadian dollars"
        },
        "narrow": "$",
        "symbol": "BBD"
      },
      "BDT": {
        "displayName": {
          "one": "Bangladeshi taka",
          "other": "Bangladeshi takas"
        },
        "narrow": "৳",
        "symbol": "BDT"
      },
      "BGN": {
        "displayName": {
          "one": "Bulgarian lev",
          "other": "Bulgarian leva"
        },
        "narrow": "BGN",
        "symbol": "BGN"
      },
      "BHD": {
        "displayName": {
          "one": "Bahraini dinar",
          "other": "Bahraini dinars"
        },
        "narrow": "BHD",
        "symbol": "BHD"
      },
      "BIF": {
        "displayName": {
          "one": "Burundian franc",
          "other": "Burundian francs"
        },
        "narrow": "BIF",
        "symbol": "BIF"
      },
      "BMD": {
        "displayName": {
          "one": "Bermudan dollar",
          "other": "Bermudan dollars"
        },
        "narrow": "$",
        "symbol": "BMD"
      },
      "BND": {
        "displayName": {
          "one": "Brunei dollar",
          "other": "Brunei dollars"
        },
        "narrow": "$",
        "symbol": "BND"
      },
      "BOB": {
        "displayName": {
          "one": "Bolivian boliviano",
          "other": "Bolivian bolivianos"
        },
        "narrow": "Bs",
        "symbol": "BOB"
      },
      "BRL": {
        "displayName": {
          "one": "Brazilian real",
          "other": "Brazilian reals"
        },
        "narrow": "R$",
        "symbol": "R$"
      },
      "BSD": {
        "displayName": {
          "one": "Bahamian dollar",
          "other": "Bahamian dollars"
        },
        "narrow": "$",
        "symbol": "BSD"
      },
      "BTN": {
        "displayName": {
          "one": "Bhutanese ngultrum",
          "other": "Bhutanese ngultrums"
        },
        "narrow": "BTN",
        "symbol": "BTN"
      },
      "BWP": {
        "displayName": {
          "one": "Botswanan pula",
          "other": "Botswanan pulas"
        },
        "narrow": "P",
        "symbol": "BWP"
      },
      "BYN": {
        "displayName": {
          "one": "Belarusian ruble",
          "other": "Belarusian rubles"
        },
        "narrow": "BYN",
        "symbol": "BYN"
      },
      "BZD": {
        "displayName": {
          "one": "Belize dollar",
          "other": "Belize dollars"
        },
        "narrow": "$",
        "symbol": "BZD"
      },
      "CAD": {
        "displayName": {
          "one": "Canadian dollar",
          "other": "Canadian dollars"
        },
        "narrow": "$",
        "symbol": "CA$"
      },
      "CDF": {
        "displayName": {
          "one": "Congolese franc",
          "other": "Congolese francs"
        },
        "narrow": "CDF",
        "symbol": "CDF"
      },
      "CHF": {
        "displayName": {
          "one": "Swiss franc",
          "other": "Swiss francs"
        },
        "narrow": "CHF",
        "symbol": "CHF"
      },
      "CLP": {
        "displayName": {
          "one": "Chilean peso",
          "other": "Chilean pesos"
        },
        "narrow": "$",
        "symbol": "CLP"
      },
      "CNH": {
        "displayName": {
          "other": "Chinese yuan (offshore)"
        },
        "narrow": "CNH",
        "symbol": "CNH"
      },
      "CNY": {
        "displayName": {
          "other": "Chinese yuan"
        },
        "narrow": "¥",
        "symbol": "CN¥"
      },
      "COP": {
        "displayName": {
          "one": "Colombian peso",
          "other": "Colombian pesos"
        },
        "narrow": "$",
        "symbol": "COP"
      },
      "CRC": {
        "displayName": {
          "one": "Costa Rican colon",
          "other": "Costa Rican colóns"
        },
        "narrow": "₡",
        "symbol": "CRC"
      },
      "CUC": {
        "displayName": {
          "one": "Cuban convertible peso",
          "other": "Cuban convertible pesos"
        },
        "narrow": "$",
        "symbol": "CUC"
      },
      "CUP": {
        "displayName": {
          "one": "Cuban peso",
          "other": "Cuban pesos"
        },
        "narrow": "$",
        "symbol": "CUP"
      },
      "CVE": {
        "displayName": {
          "one": "Cape Verdean escudo",
          "other": "Cape Verdean escudos"
        },
        "narrow": "CVE",
        "symbol": "CVE"
      },
      "CZK": {
        "displayName": {
          "one": "Czech koruna",
          "other": "Czech korunas"
        },
        "narrow": "Kč",
        "symbol": "CZK"
      },
      "DJF": {
        "displayName": {
          "one": "Djiboutian franc",
          "other": "Djiboutian francs"
        },
        "narrow": "DJF",
        "symbol": "DJF"
      },
      "DKK": {
        "displayName": {
          "one": "Danish krone",
          "other": "Danish kroner"
        },
        "narrow": "kr",
        "symbol": "DKK"
      },
      "DOP": {
        "displayName": {
          "one": "Dominican peso",
          "other": "Dominican pesos"
        },
        "narrow": "$",
        "symbol": "DOP"
      },
      "DZD": {
        "displayName": {
          "one": "Algerian dinar",
          "other": "Algerian dinars"
        },
        "narrow": "DZD",
        "symbol": "DZD"
      },
      "EGP": {
        "displayName": {
          "one": "Egyptian pound",
          "other": "Egyptian pounds"
        },
        "narrow": "E£",
        "symbol": "EGP"
      },
      "ERN": {
        "displayName": {
          "one": "Eritrean nakfa",
          "other": "Eritrean nakfas"
        },
        "narrow": "ERN",
        "symbol": "ERN"
      },
      "ESP": {
        "displayName": {
        },
        "narrow": "₧",
        "symbol": "ESP"
      },
      "ETB": {
        "displayName": {
          "one": "Ethiopian birr",
          "other": "Ethiopian birrs"
        },
        "narrow": "ETB",
        "symbol": "ETB"
      },
      "EUR": {
        "displayName": {
          "one": "euro",
          "other": "euros"
        },
        "narrow": "€",
        "symbol": "€"
      },
      "FJD": {
        "displayName": {
          "one": "Fijian dollar",
          "other": "Fijian dollars"
        },
        "narrow": "$",
        "symbol": "FJD"
      },
      "FKP": {
        "displayName": {
          "one": "Falkland Islands pound",
          "other": "Falkland Islands pounds"
        },
        "narrow": "£",
        "symbol": "FKP"
      },
      "GBP": {
        "displayName": {
          "one": "British pound",
          "other": "British pounds"
        },
        "narrow": "£",
        "symbol": "£"
      },
      "GEL": {
        "displayName": {
          "one": "Georgian lari",
          "other": "Georgian laris"
        },
        "narrow": "₾",
        "symbol": "GEL"
      },
      "GHS": {
        "displayName": {
          "one": "Ghanaian cedi",
          "other": "Ghanaian cedis"
        },
        "narrow": "GH₵",
        "symbol": "GHS"
      },
      "GIP": {
        "displayName": {
          "one": "Gibraltar pound",
          "other": "Gibraltar pounds"
        },
        "narrow": "£",
        "symbol": "GIP"
      },
      "GMD": {
        "displayName": {
          "one": "Gambian dalasi",
          "other": "Gambian dalasis"
        },
        "narrow": "GMD",
        "symbol": "GMD"
      },
      "GNF": {
        "displayName": {
          "one": "Guinean franc",
          "other": "Guinean francs"
        },
        "narrow": "FG",
        "symbol": "GNF"
      },
      "GTQ": {
        "displayName": {
          "one": "Guatemalan quetzal",
          "other": "Guatemalan quetzals"
        },
        "narrow": "Q",
        "symbol": "GTQ"
      },
      "GYD": {
        "displayName": {
          "one": "Guyanaese dollar",
          "other": "Guyanaese dollars"
        },
        "narrow": "$",
        "symbol": "GYD"
      },
      "HKD": {
        "displayName": {
          "one": "Hong Kong dollar",
          "other": "Hong Kong dollars"
        },
        "narrow": "$",
        "symbol": "HK$"
      },
      "HNL": {
        "displayName": {
          "one": "Honduran lempira",
          "other": "Honduran lempiras"
        },
        "narrow": "L",
        "symbol": "HNL"
      },
      "HRK": {
        "displayName": {
          "one": "Croatian kuna",
          "other": "Croatian kunas"
        },
        "narrow": "kn",
        "symbol": "HRK"
      },
      "HTG": {
        "displayName": {
          "one": "Haitian gourde",
          "other": "Haitian gourdes"
        },
        "narrow": "HTG",
        "symbol": "HTG"
      },
      "HUF": {
        "displayName": {
          "one": "Hungarian forint",
          "other": "Hungarian forints"
        },
        "narrow": "Ft",
        "symbol": "HUF"
      },
      "IDR": {
        "displayName": {
          "one": "Indonesian rupiah",
          "other": "Indonesian rupiahs"
        },
        "narrow": "Rp",
        "symbol": "IDR"
      },
      "ILS": {
        "displayName": {
          "one": "Israeli new shekel",
          "other": "Israeli new shekels"
        },
        "narrow": "₪",
        "symbol": "₪"
      },
      "INR": {
        "displayName": {
          "one": "Indian rupee",
          "other": "Indian rupees"
        },
        "narrow": "₹",
        "symbol": "₹"
      },
      "IQD": {
        "displayName": {
          "one": "Iraqi dinar",
          "other": "Iraqi dinars"
        },
        "narrow": "IQD",
        "symbol": "IQD"
      },
      "IRR": {
        "displayName": {
          "one": "Iranian rial",
          "other": "Iranian rials"
        },
        "narrow": "IRR",
        "symbol": "IRR"
      },
      "ISK": {
        "displayName": {
          "one": "Icelandic krona",
          "other": "Icelandic kronur"
        },
        "narrow": "kr",
        "symbol": "ISK"
      },
      "JMD": {
        "displayName": {
          "one": "Jamaican dollar",
          "other": "Jamaican dollars"
        },
        "narrow": "$",
        "symbol": "JMD"
      },
      "JOD": {
        "displayName": {
          "one": "Jordanian dinar",
          "other": "Jordanian dinars"
        },
        "narrow": "JOD",
        "symbol": "JOD"
      },
      "JPY": {
        "displayName": {
          "other": "Japanese yen"
        },
        "narrow": "¥",
        "symbol": "JP¥"
      },
      "KES": {
        "displayName": {
          "one": "Kenyan shilling",
          "other": "Kenyan shillings"
        },
        "narrow": "KES",
        "symbol": "KES"
      },
      "KGS": {
        "displayName": {
          "one": "Kyrgystani som",
          "other": "Kyrgystani soms"
        },
        "narrow": "⃀",
        "symbol": "KGS"
      },
      "KHR": {
        "displayName": {
          "one": "Cambodian riel",
          "other": "Cambodian riels"
        },
        "narrow": "៛",
        "symbol": "KHR"
      },
      "KMF": {
        "displayName": {
          "one": "Comorian franc",
          "other": "Comorian francs"
        },
        "narrow": "CF",
        "symbol": "KMF"
      },
      "KPW": {
        "displayName": {
          "other": "North Korean won"
        },
        "narrow": "₩",
        "symbol": "KPW"
      },
      "KRW": {
        "displayName": {
          "other": "South Korean won"
        },
        "narrow": "₩",
        "symbol": "₩"
      },
      "KWD": {
        "displayName": {
          "one": "Kuwaiti dinar",
          "other": "Kuwaiti dinars"
        },
        "narrow": "KWD",
        "symbol": "KWD"
      },
      "KYD": {
        "displayName": {
          "one": "Cayman Islands dollar",
          "other": "Cayman Islands dollars"
        },
        "narrow": "$",
        "symbol": "KYD"
      },
      "KZT": {
        "displayName": {
          "one": "Kazakhstani tenge",
          "other": "Kazakhstani tenges"
        },
        "narrow": "₸",
        "symbol": "KZT"
      },
      "LAK": {
        "displayName": {
          "one": "Laotian kip",
          "other": "Laotian kips"
        },
        "narrow": "₭",
        "symbol": "LAK"
      },
      "LBP": {
        "displayName": {
          "one": "Lebanese pound",
          "other": "Lebanese pounds"
        },
        "narrow": "L£",
        "symbol": "LBP"
      },
      "LKR": {
        "displayName": {
          "one": "Sri Lankan rupee",
          "other": "Sri Lankan rupees"
        },
        "narrow": "Rs",
        "symbol": "LKR"
      },
      "LRD": {
        "displayName": {
          "one": "Liberian dollar",
          "other": "Liberian dollars"
        },
        "narrow": "$",
        "symbol": "LRD"
      },
      "LSL": {
        "displayName": {
          "one": "Lesotho loti",
          "other": "Lesotho lotis"
        },
        "narrow": "LSL",
        "symbol": "LSL"
      },
      "LTL": {
        "displayName": {
        },
        "narrow": "Lt",
        "symbol": "LTL"
      },
      "LVL": {
        "displayName": {
        },
        "narrow": "Ls",
        "symbol": "LVL"
      },
      "LYD": {
        "displayName": {
          "one": "Libyan dinar",
          "other": "Libyan dinars"
        },
        "narrow": "LYD",
        "symbol": "LYD"
      },
      "MAD": {
        "displayName": {
          "one": "Moroccan dirham",
          "other": "Moroccan dirhams"
        },
        "narrow": "MAD",
        "symbol": "MAD"
      },
      "MDL": {
        "displayName": {
          "one": "Moldovan leu",
          "other": "Moldovan lei"
        },
        "narrow": "MDL",
        "symbol": "MDL"
      },
      "MGA": {
        "displayName": {
          "one": "Malagasy ariary",
          "other": "Malagasy ariaries"
        },
        "narrow": "Ar",
        "symbol": "MGA"
      },
      "MKD": {
        "displayName": {
          "one": "Macedonian denar",
          "other": "Macedonian denari"
        },
        "narrow": "MKD",
        "symbol": "MKD"
      },
      "MMK": {
        "displayName": {
          "one": "Myanmar kyat",
          "other": "Myanmar kyats"
        },
        "narrow": "K",
        "symbol": "MMK"
      },
      "MNT": {
        "displayName": {
          "one": "Mongolian tugrik",
          "other": "Mongolian tugriks"
        },
        "narrow": "₮",
        "symbol": "MNT"
      },
      "MOP": {
        "displayName": {
          "one": "Macanese pataca",
          "other": "Macanese patacas"
        },
        "narrow": "MOP",
        "symbol": "MOP"
      },
      "MRU": {
        "displayName": {
          "one": "Mauritanian ouguiya",
          "other": "Mauritanian ouguiyas"
        },
        "narrow": "MRU",
        "symbol": "MRU"
      },
      "MUR": {
        "displayName": {
          "one": "Mauritian rupee",
          "other": "Mauritian rupees"
        },
        "narrow": "Rs",
        "symbol": "MUR"
      },
      "MVR": {
        "displayName": {
          "one": "Maldivian rufiyaa",
          "other": "Maldivian rufiyaas"
        },
        "narrow": "MVR",
        "symbol": "MVR"
      },
      "MWK": {
        "displayName": {
          "one": "Malawian kwacha",
          "other": "Malawian kwachas"
        },
        "narrow": "MWK",
        "symbol": "MWK"
      },
      "MXN": {
        "displayName": {
          "one": "Mexican peso",
          "other": "Mexican pesos"
        },
        "narrow": "$",
        "symbol": "MX$"
      },
      "MYR": {
        "displayName": {
          "one": "Malaysian ringgit",
          "other": "Malaysian ringgits"
        },
        "narrow": "RM",
        "symbol": "MYR"
      },
      "MZN": {
        "displayName": {
          "one": "Mozambican metical",
          "other": "Mozambican meticals"
        },
        "narrow": "MZN",
        "symbol": "MZN"
      },
      "NAD": {
        "displayName": {
          "one": "Namibian dollar",
          "other": "Namibian dollars"
        },
        "narrow": "$",
        "symbol": "NAD"
      },
      "NGN": {
        "displayName": {
          "one": "Nigerian naira",
          "other": "Nigerian nairas"
        },
        "narrow": "₦",
        "symbol": "NGN"
      },
      "NIO": {
        "displayName": {
          "one": "Nicaraguan cordoba",
          "other": "Nicaraguan córdobas"
        },
        "narrow": "C$",
        "symbol": "NIO"
      },
      "NOK": {
        "displayName": {
          "one": "Norwegian krone",
          "other": "Norwegian kroner"
        },
        "narrow": "kr",
        "symbol": "NOK"
      },
      "NPR": {
        "displayName": {
          "one": "Nepalese rupee",
          "other": "Nepalese rupees"
        },
        "narrow": "Rs",
        "symbol": "NPR"
      },
      "NZD": {
        "displayName": {
          "one": "New Zealand dollar",
          "other": "New Zealand dollars"
        },
        "narrow": "$",
        "symbol": "NZ$"
      },
      "OMR": {
        "displayName": {
          "one": "Omani rial",
          "other": "Omani rials"
        },
        "narrow": "OMR",
        "symbol": "OMR"
      },
      "PAB": {
        "displayName": {
          "one": "Panamanian balboa",
          "other": "Panamanian balboas"
        },
        "narrow": "PAB",
        "symbol": "PAB"
      },
      "PEN": {
        "displayName": {
          "one": "Peruvian sol",
          "other": "Peruvian soles"
        },
        "narrow": "PEN",
        "symbol": "PEN"
      },
      "PGK": {
        "displayName": {
          "other": "Papua New Guinean kina"
        },
        "narrow": "PGK",
        "symbol": "PGK"
      },
      "PHP": {
        "displayName": {
          "one": "Philippine peso",
          "other": "Philippine pesos"
        },
        "narrow": "₱",
        "symbol": "₱"
      },
      "PKR": {
        "displayName": {
          "one": "Pakistani rupee",
          "other": "Pakistani rupees"
        },
        "narrow": "Rs",
        "symbol": "PKR"
      },
      "PLN": {
        "displayName": {
          "one": "Polish zloty",
          "other": "Polish zlotys"
        },
        "narrow": "zł",
        "symbol": "PLN"
      },
      "PYG": {
        "displayName": {
          "one": "Paraguayan guarani",
          "other": "Paraguayan guaranis"
        },
        "narrow": "₲",
        "symbol": "PYG"
      },
      "QAR": {
        "displayName": {
          "one": "Qatari rial",
          "other": "Qatari riyals"
        },
        "narrow": "QAR",
        "symbol": "QAR"
      },
      "RON": {
        "displayName": {
          "one": "Romanian leu",
          "other": "Romanian lei"
        },
        "narrow": "lei",
        "symbol": "RON"
      },
      "RSD": {
        "displayName": {
          "one": "Serbian dinar",
          "other": "Serbian dinars"
        },
        "narrow": "RSD",
        "symbol": "RSD"
      },
      "RUB": {
        "displayName": {
          "one": "Russian ruble",
          "other": "Russian rubles"
        },
        "narrow": "₽",
        "symbol": "RUB"
      },
      "RWF": {
        "displayName": {
          "one": "Rwandan franc",
          "other": "Rwandan francs"
        },
        "narrow": "RF",
        "symbol": "RWF"
      },
      "SAR": {
        "displayName": {
          "one": "Saudi riyal",
          "other": "Saudi riyals"
        },
        "narrow": "SAR",
        "symbol": "SAR"
      },
      "SBD": {
        "displayName": {
          "one": "Solomon Islands dollar",
          "other": "Solomon Islands dollars"
        },
        "narrow": "$",
        "symbol": "SBD"
      },
      "SCR": {
        "displayName": {
          "one": "Seychellois rupee",
          "other": "Seychellois rupees"
        },
        "narrow": "SCR",
        "symbol": "SCR"
      },
      "SDG": {
        "displayName": {
          "one": "Sudanese pound",
          "other": "Sudanese pounds"
        },
        "narrow": "SDG",
        "symbol": "SDG"
      },
      "SEK": {
        "displayName": {
          "one": "Swedish krona",
          "other": "Swedish kronor"
        },
        "narrow": "kr",
        "symbol": "SEK"
      },
      "SGD": {
        "displayName": {
          "one": "Singapore dollar",
          "other": "Singapore dollars"
        },
        "narrow": "$",
        "symbol": "SGD"
      },
      "SHP": {
        "displayName": {
          "one": "St. Helena pound",
          "other": "St. Helena pounds"
        },
        "narrow": "£",
        "symbol": "SHP"
      },
      "SLE": {
        "displayName": {
          "one": "Sierra Leonean leone",
          "other": "Sierra Leonean leones"
        },
        "narrow": "SLE",
        "symbol": "SLE"
      },
      "SLL": {
        "displayName": {
          "one": "Sierra Leonean leone (1964—2022)",
          "other": "Sierra Leonean leones (1964—2022)"
        },
        "narrow": "SLL",
        "symbol": "SLL"
      },
      "SOS": {
        "displayName": {
          "one": "Somali shilling",
          "other": "Somali shillings"
        },
        "narrow": "SOS",
        "symbol": "SOS"
      },
      "SRD": {
        "displayName": {
          "one": "Surinamese dollar",
          "other": "Surinamese dollars"
        },
        "narrow": "$",
        "symbol": "SRD"
      },
      "SSP": {
        "displayName": {
          "one": "South Sudanese pound",
          "other": "South Sudanese pounds"
        },
        "narrow": "£",
        "symbol": "SSP"
      },
      "STN": {
        "displayName": {
          "one": "Sao Tome & Principe dobra",
          "other": "São Tomé & Príncipe dobras"
        },
        "narrow": "Db",
        "symbol": "STN"
      },
      "SYP": {
        "displayName": {
          "one": "Syrian pound",
          "other": "Syrian pounds"
        },
        "narrow": "£",
        "symbol": "SYP"
      },
      "SZL": {
        "displayName": {
          "one": "Swazi lilangeni",
          "other": "Swazi emalangeni"
        },
        "narrow": "SZL",
        "symbol": "SZL"
      },
      "THB": {
        "displayName": {
          "other": "Thai baht"
        },
        "narrow": "฿",
        "symbol": "THB"
      },
      "TJS": {
        "displayName": {
          "one": "Tajikistani somoni",
          "other": "Tajikistani somonis"
        },
        "narrow": "TJS",
        "symbol": "TJS"
      },
      "TMT": {
        "displayName": {
          "other": "Turkmenistani manat"
        },
        "narrow": "TMT",
        "symbol": "TMT"
      },
      "TND": {
        "displayName": {
          "one": "Tunisian dinar",
          "other": "Tunisian dinars"
        },
        "narrow": "TND",
        "symbol": "TND"
      },
      "TOP": {
        "displayName": {
          "other": "Tongan paʻanga"
        },
        "narrow": "T$",
        "symbol": "TOP"
      },
      "TRY": {
        "displayName": {
          "one": "Turkish lira",
          "other": "Turkish Lira"
        },
        "narrow": "₺",
        "symbol": "TRY"
      },
      "TTD": {
        "displayName": {
          "one": "Trinidad & Tobago dollar",
          "other": "Trinidad & Tobago dollars"
        },
        "narrow": "$",
        "symbol": "TTD"
      },
      "TWD": {
        "displayName": {
          "one": "New Taiwan dollar",
          "other": "New Taiwan dollars"
        },
        "narrow": "$",
        "symbol": "NT$"
      },
      "TZS": {
        "displayName": {
          "one": "Tanzanian shilling",
          "other": "Tanzanian shillings"
        },
        "narrow": "TZS",
        "symbol": "TZS"
      },
      "UAH": {
        "displayName": {
          "one": "Ukrainian hryvnia",
          "other": "Ukrainian hryvnias"
        },
        "narrow": "₴",
        "symbol": "UAH"
      },
      "UGX": {
        "displayName": {
          "one": "Ugandan shilling",
          "other": "Ugandan shillings"
        },
        "narrow": "UGX",
        "symbol": "UGX"
      },
      "USD": {
        "displayName": {
          "one": "US dollar",
          "other": "US dollars"
        },
        "narrow": "$",
        "symbol": "US $"
      },
      "UYU": {
        "displayName": {
          "one": "Uruguayan peso",
          "other": "Uruguayan pesos"
        },
        "narrow": "$",
        "symbol": "UYU"
      },
      "UZS": {
        "displayName": {
          "other": "Uzbekistani som"
        },
        "narrow": "UZS",
        "symbol": "UZS"
      },
      "VEF": {
        "displayName": {
        },
        "narrow": "Bs",
        "symbol": "VEF"
      },
      "VES": {
        "displayName": {
          "one": "Venezuelan bolivar",
          "other": "Venezuelan bolívars"
        },
        "narrow": "VES",
        "symbol": "VES"
      },
      "VND": {
        "displayName": {
          "other": "Vietnamese dong"
        },
        "narrow": "₫",
        "symbol": "₫"
      },
      "VUV": {
        "displayName": {
          "one": "Vanuatu vatu",
          "other": "Vanuatu vatus"
        },
        "narrow": "VUV",
        "symbol": "VUV"
      },
      "WST": {
        "displayName": {
          "other": "Samoan tala"
        },
        "narrow": "WST",
        "symbol": "WST"
      },
      "XAF": {
        "displayName": {
          "one": "Central African CFA franc",
          "other": "Central African CFA francs"
        },
        "narrow": "FCFA",
        "symbol": "FCFA"
      },
      "XCD": {
        "displayName": {
          "one": "East Caribbean dollar",
          "other": "East Caribbean dollars"
        },
        "narrow": "$",
        "symbol": "EC$"
      },
      "XCG": {
        "displayName": {
        },
        "narrow": "Cg.",
        "symbol": "Cg."
      },
      "XOF": {
        "displayName": {
          "one": "West African CFA franc",
          "other": "West African CFA francs"
        },
        "narrow": "F CFA",
        "symbol": "F CFA"
      },
      "XPF": {
        "displayName": {
          "one": "CFP franc",
          "other": "CFP francs"
        },
        "narrow": "CFPF",
        "symbol": "CFPF"
      },
      "XXX": {
        "displayName": {
          "one": "(wala mailhi nga yunit sa kwarta)",
          "other": "(wala mailhi nga kwarta)"
        },
        "narrow": "¤",
        "symbol": "¤"
      },
      "YER": {
        "displayName": {
          "one": "Yemeni rial",
          "other": "Yemeni rials"
        },
        "narrow": "YER",
        "symbol": "YER"
      },
      "ZAR": {
        "displayName": {
          "other": "South African rand"
        },
        "narrow": "R",
        "symbol": "ZAR"
      },
      "ZMW": {
        "displayName": {
          "one": "Zambian kwacha",
          "other": "Zambian kwachas"
        },
        "narrow": "ZK",
        "symbol": "ZMW"
      }
    },
    "nu": [
      "latn"
    ],
    "numbers": {
      "currency": {
        "latn": {
          "accounting": "¤#,##0.00;(¤#,##0.00)",
          "currencySpacing": {
            "afterInsertBetween": " ",
            "beforeInsertBetween": " "
          },
          "short": {
            "1000": {
              "other": "¤ 0K"
            },
            "10000": {
              "other": "¤ 00K"
            },
            "100000": {
              "other": "¤ 000K"
            },
            "1000000": {
              "other": "¤ 0M"
            },
            "10000000": {
              "other": "¤ 00M"
            },
            "100000000": {
              "other": "¤ 000M"
            },
            "1000000000": {
              "other": "¤ 0G"
            },
            "10000000000": {
              "other": "¤ 00G"
            },
            "100000000000": {
              "other": "¤ 000G"
            },
            "1000000000000": {
              "other": "¤ 0T"
            },
            "10000000000000": {
              "other": "¤ 00T"
            },
            "100000000000000": {
              "other": "¤ 000T"
            }
          },
          "standard": "¤#,##0.00",
          "unitPattern": "{1} {0}"
        }
      },
      "decimal": {
        "latn": {
          "long": {
            "1000": {
              "other": "0K"
            },
            "10000": {
              "other": "00K"
            },
            "100000": {
              "other": "000K"
            },
            "1000000": {
              "other": "0M"
            },
            "10000000": {
              "other": "00M"
            },
            "100000000": {
              "other": "000M"
            },
            "1000000000": {
              "other": "0G"
            },
            "10000000000": {
              "other": "00G"
            },
            "100000000000": {
              "other": "000G"
            },
            "1000000000000": {
              "other": "0T"
            },
            "10000000000000": {
              "other": "00T"
            },
            "100000000000000": {
              "other": "000T"
            }
          },
          "short": {
            "1000": {
              "other": "0K"
            },
            "10000": {
              "other": "00K"
            },
            "100000": {
              "other": "000K"
            },
            "1000000": {
              "other": "0M"
            },
            "10000000": {
              "other": "00M"
            },
            "100000000": {
              "other": "000M"
            },
            "1000000000": {
              "other": "0G"
            },
            "10000000000": {
              "other": "00G"
            },
            "100000000000": {
              "other": "000G"
            },
            "1000000000000": {
              "other": "0T"
            },
            "10000000000000": {
              "other": "00T"
            },
            "100000000000000": {
              "other": "000T"
            }
          },
          "standard": "#,##0.###"
        }
      },
      "nu": [
        "latn"
      ],
      "percent": {
        "latn": "#,##0%"
      },
      "symbols": {
        "latn": {
          "approximatelySign": "~",
          "decimal": ".",
          "exponential": "E",
          "group": ",",
          "infinity": "∞",
          "list": ";",
          "minusSign": "-",
          "nan": "NaN",
          "perMille": "‰",
          "percentSign": "%",
          "plusSign": "+",
          "rangeSign": "–",
          "superscriptingExponent": "×",
          "timeSeparator": ":"
        }
      }
    },
    "units": {
      "compound": {
        "per": {
          "long": "{0} kada {1}",
          "narrow": "{0}/{1}",
          "short": "{0}/{1}"
        }
      },
      "simple": {
        "acre": {
          "long": {
            "one": "{0} ka acre",
            "other": "{0} ka mga acre"
          },
          "narrow": {
            "other": "{0} ac"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ac"
          }
        },
        "bit": {
          "long": {
            "one": "{0} ka bit",
            "other": "{0} ka mga bit"
          },
          "narrow": {
            "other": "{0} ka bit"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ka bit"
          }
        },
        "byte": {
          "long": {
            "one": "{0} ka byte",
            "other": "{0} ka mga byte"
          },
          "narrow": {
            "other": "{0} ka byte"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ka byte"
          }
        },
        "celsius": {
          "long": {
            "one": "{0} ka degree Celsius",
            "other": "{0} degree Celsius"
          },
          "narrow": {
            "other": "{0}°C"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0}°C"
          }
        },
        "centimeter": {
          "long": {
            "one": "{0} ka sentimetro",
            "other": "{0} ka mga sentimetro"
          },
          "narrow": {
            "other": "{0}cm"
          },
          "perUnit": {
            "long": "{0} kada sentimetro",
            "narrow": "{0}/cm",
            "short": "{0}/cm"
          },
          "short": {
            "other": "{0} cm"
          }
        },
        "day": {
          "long": {
            "one": "{0} ka adlaw",
            "other": "{0} ka mga adlaw"
          },
          "narrow": {
            "other": "{0} adlaw"
          },
          "perUnit": {
            "long": "{0} kada adlaw",
            "narrow": "{0}/adlaw",
            "short": "{0}/adlaw"
          },
          "short": {
            "other": "{0} ka adlaw"
          }
        },
        "degree": {
          "long": {
            "one": "{0} ka degree",
            "other": "{0} ka mga degree"
          },
          "narrow": {
            "other": "{0} deg"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} deg"
          }
        },
        "fahrenheit": {
          "long": {
            "other": "{0} degree Fahrenheit"
          },
          "narrow": {
            "other": "{0}°F"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0}°F"
          }
        },
        "fluid-ounce": {
          "long": {
            "one": "{0} ka fluid ounce",
            "other": "{0} ka mga fluid ounce"
          },
          "narrow": {
            "other": "{0} fl oz"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} fl oz"
          }
        },
        "foot": {
          "long": {
            "one": "{0} ka piye",
            "other": "{0} ka mga piye"
          },
          "narrow": {
            "other": "{0} ft"
          },
          "perUnit": {
            "long": "{0} kada piye",
            "narrow": "{0}/ft",
            "short": "{0}/ft"
          },
          "short": {
            "other": "{0} ft"
          }
        },
        "gallon": {
          "long": {
            "one": "{0} ka gallon",
            "other": "{0} ka mga gallon"
          },
          "narrow": {
            "other": "{0} gal"
          },
          "perUnit": {
            "long": "{0} kada gallon",
            "narrow": "{0}/gal US",
            "short": "{0}/gal US"
          },
          "short": {
            "other": "{0} gal"
          }
        },
        "gigabit": {
          "long": {
            "one": "{0} ka gigabit",
            "other": "{0} ka mga gigabit"
          },
          "narrow": {
            "other": "{0} Gb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} Gb"
          }
        },
        "gigabyte": {
          "long": {
            "one": "{0} ka gigabyte",
            "other": "{0} ka mga gigabyte"
          },
          "narrow": {
            "other": "{0} GB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} GB"
          }
        },
        "gram": {
          "long": {
            "one": "{0} ka gramo",
            "other": "{0} ka mga gramo"
          },
          "narrow": {
            "other": "{0} g"
          },
          "perUnit": {
            "long": "{0} kada gramo",
            "narrow": "{0}/g",
            "short": "{0}/g"
          },
          "short": {
            "other": "{0} g"
          }
        },
        "hectare": {
          "long": {
            "one": "{0} ka ektarya",
            "other": "{0} ka mga ektarya"
          },
          "narrow": {
            "other": "{0} ha"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ha"
          }
        },
        "hour": {
          "long": {
            "one": "{0} ka oras",
            "other": "{0} ka mga oras"
          },
          "narrow": {
            "other": "{0} ka oras"
          },
          "perUnit": {
            "long": "{0} kada oras",
            "narrow": "{0}/oras",
            "short": "{0}/oras"
          },
          "short": {
            "other": "{0} ka oras"
          }
        },
        "inch": {
          "long": {
            "other": "{0} ka pulgada"
          },
          "narrow": {
            "other": "{0} in"
          },
          "perUnit": {
            "long": "{0} kada pulgada",
            "narrow": "{0}/in",
            "short": "{0}/in"
          },
          "short": {
            "other": "{0} in"
          }
        },
        "kilobit": {
          "long": {
            "one": "{0} ka kilobit",
            "other": "{0} ka mga kilobit"
          },
          "narrow": {
            "other": "{0} kb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} kb"
          }
        },
        "kilobyte": {
          "long": {
            "one": "{0} ka kilobyte",
            "other": "{0} ka mga kilobyte"
          },
          "narrow": {
            "other": "{0} kB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} kB"
          }
        },
        "kilogram": {
          "long": {
            "one": "{0} ka kilogramo",
            "other": "{0} ka mga kilogramo"
          },
          "narrow": {
            "other": "{0}kg"
          },
          "perUnit": {
            "long": "{0} kada kilogramo",
            "narrow": "{0}/kg",
            "short": "{0}/kg"
          },
          "short": {
            "other": "{0} kg"
          }
        },
        "kilometer": {
          "long": {
            "one": "{0} ka kilometro",
            "other": "{0} ka mga kilometro"
          },
          "narrow": {
            "other": "{0}km"
          },
          "perUnit": {
            "long": "{0} kada kilometro",
            "narrow": "{0}/km",
            "short": "{0}/km"
          },
          "short": {
            "other": "{0} km"
          }
        },
        "kilometer-per-hour": {
          "long": {
            "one": "{0} ka kilometro kada oras",
            "other": "{0} ka mga kilometro kada oras"
          },
          "narrow": {
            "other": "{0}km/h"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} km/h"
          }
        },
        "liter": {
          "long": {
            "one": "{0} ka litro",
            "other": "{0} ka mga litro"
          },
          "narrow": {
            "other": "{0}L"
          },
          "perUnit": {
            "long": "{0} kada litro",
            "narrow": "{0}/L",
            "short": "{0}/L"
          },
          "short": {
            "other": "{0} L"
          }
        },
        "liter-per-kilometer": {
          "long": {
            "one": "{0} litro kada kilometro",
            "other": "{0} ka mga litro kada kilometro"
          },
          "narrow": {
            "other": "{0} L/km"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} L/km"
          }
        },
        "megabit": {
          "long": {
            "one": "{0} ka megabit",
            "other": "{0} ka mga megabit"
          },
          "narrow": {
            "other": "{0} Mb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} Mb"
          }
        },
        "megabyte": {
          "long": {
            "one": "{0} ka megabyte",
            "other": "{0} ka mga megabyte"
          },
          "narrow": {
            "other": "{0} MB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} MB"
          }
        },
        "meter": {
          "long": {
            "one": "{0} ka metro",
            "other": "{0} ka mga metro"
          },
          "narrow": {
            "other": "{0}m"
          },
          "perUnit": {
            "long": "{0} kada metro",
            "narrow": "{0}/m",
            "short": "{0}/m"
          },
          "short": {
            "other": "{0} m"
          }
        },
        "meter-per-second": {
          "long": {
            "one": "{0} ka metro kada segundo",
            "other": "{0} ka mga metro kada segundo"
          },
          "narrow": {
            "other": "{0} m/s"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} m/s"
          }
        },
        "mile": {
          "long": {
            "one": "{0} ka milya",
            "other": "{0} ka mga milya"
          },
          "narrow": {
            "other": "{0} mi"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mi"
          }
        },
        "mile-per-gallon": {
          "long": {
            "one": "{0} ka milya kada gallon",
            "other": "{0} ka mga milya kada gallon"
          },
          "narrow": {
            "other": "{0} mpg"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mpg"
          }
        },
        "mile-per-hour": {
          "long": {
            "one": "{0} ka milya kada oras",
            "other": "{0} ka mga milya kada oras"
          },
          "narrow": {
            "other": "{0} mph"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mph"
          }
        },
        "mile-scandinavian": {
          "long": {
            "other": "{0} ka mile-scandinavian"
          },
          "narrow": {
            "other": "{0} smi"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} smi"
          }
        },
        "milliliter": {
          "long": {
            "one": "{0} ka milliliter",
            "other": "{0} ka mga milliliter"
          },
          "narrow": {
            "other": "{0} mL"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mL"
          }
        },
        "millimeter": {
          "long": {
            "other": "{0} ka millimetro"
          },
          "narrow": {
            "other": "{0}mm"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mm"
          }
        },
        "millisecond": {
          "long": {
            "one": "{0} ka millisecond",
            "other": "{0} ka mga millisecond"
          },
          "narrow": {
            "other": "{0}ms"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ms"
          }
        },
        "minute": {
          "long": {
            "one": "{0} ka minuto",
            "other": "{0} ka mga minuto"
          },
          "narrow": {
            "other": "{0} minuto"
          },
          "perUnit": {
            "long": "{0} kada minuto",
            "narrow": "{0}/minuto",
            "short": "{0}/minuto"
          },
          "short": {
            "other": "{0} ka minuto"
          }
        },
        "month": {
          "long": {
            "one": "{0} ka buwan",
            "other": "{0} ka mga buwan"
          },
          "narrow": {
            "other": "{0} buwan"
          },
          "perUnit": {
            "long": "{0} kada buwan",
            "narrow": "{0}/buwan",
            "short": "{0}/buwan"
          },
          "short": {
            "other": "{0} ka buwan"
          }
        },
        "ounce": {
          "long": {
            "one": "{0} ka ounce",
            "other": "{0} ka mga ounce"
          },
          "narrow": {
            "other": "{0} oz"
          },
          "perUnit": {
            "long": "{0} kada ounce",
            "narrow": "{0}/oz",
            "short": "{0}/oz"
          },
          "short": {
            "other": "{0} oz"
          }
        },
        "percent": {
          "long": {
            "other": "{0} ka porsyento"
          },
          "narrow": {
            "other": "{0}%"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0}%"
          }
        },
        "petabyte": {
          "long": {
            "one": "{0} ka petabyte",
            "other": "{0} ka mga petabyte"
          },
          "narrow": {
            "other": "{0} PB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} PB"
          }
        },
        "pound": {
          "long": {
            "one": "{0} ka pound",
            "other": "{0} ka mga pound"
          },
          "narrow": {
            "other": "{0} lb"
          },
          "perUnit": {
            "long": "{0} kada pound",
            "narrow": "{0}/lb",
            "short": "{0}/lb"
          },
          "short": {
            "other": "{0} lb"
          }
        },
        "second": {
          "long": {
            "one": "{0} ka segundo",
            "other": "{0} ka mga segundo"
          },
          "narrow": {
            "other": "{0}segundo"
          },
          "perUnit": {
            "long": "{0} kada segundo",
            "narrow": "{0}/segundo",
            "short": "{0}/segundo"
          },
          "short": {
            "other": "{0}segundo"
          }
        },
        "stone": {
          "long": {
            "other": "{0} st"
          },
          "narrow": {
            "other": "{0} st"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} st"
          }
        },
        "terabit": {
          "long": {
            "one": "{0} ka terabit",
            "other": "{0} ka mga terabit"
          },
          "narrow": {
            "other": "{0} Tb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} Tb"
          }
        },
        "terabyte": {
          "long": {
            "one": "{0} ka terabyte",
            "other": "{0} ka mga terabyte"
          },
          "narrow": {
            "other": "{0} TB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} TB"
          }
        },
        "week": {
          "long": {
            "one": "{0} ka semana",
            "other": "{0} ka mga semana"
          },
          "narrow": {
            "one": "{0} semana",
            "other": "{0}w"
          },
          "perUnit": {
            "long": "{0} kada semana",
            "narrow": "{0}/semana",
            "short": "{0}/semana"
          },
          "short": {
            "other": "{0} ka semana"
          }
        },
        "yard": {
          "long": {
            "one": "{0} ka yarda",
            "other": "{0} ka mga yarda"
          },
          "narrow": {
            "other": "{0} yd"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} yd"
          }
        },
        "year": {
          "long": {
            "one": "{0} ka tuig",
            "other": "{0} ka mga tuig"
          },
          "narrow": {
            "other": "{0} ka tuig"
          },
          "perUnit": {
            "long": "{0} kada tuig",
            "narrow": "{0}/tuig",
            "short": "{0}/tuig"
          },
          "short": {
            "other": "{0} ka tuig"
          }
        }
      }
    }
  },
  "locale": "ceb"
})
}