"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addToCleanupQueue = addToCleanupQueue;
exports.default = cleanup;
var _screen = require("./screen");
const cleanupQueue = new Set();
function cleanup() {
  (0, _screen.clearRenderResult)();
  cleanupQueue.forEach(fn => fn());
  cleanupQueue.clear();
}
function addToCleanupQueue(fn) {
  cleanupQueue.add(fn);
}
//# sourceMappingURL=cleanup.js.map