"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMvcpTuner = exports.MvcpScrollViewManager = void 0;

var _react = require("react");

var _reactNative = require("react-native");

const MvcpScrollViewManager = _reactNative.NativeModules.MvcpScrollViewManager;
exports.MvcpScrollViewManager = MvcpScrollViewManager;

const useMvcpTuner = (flRef, refReady, mvcp, extraData) => {
  const autoscrollToTopThreshold = (0, _react.useRef)();
  const minIndexForVisible = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    let cleanupPromise;

    const enableMaintainVisibleContentPosition = () => {
      if (!mvcp || _reactNative.Platform.OS !== 'android' || !(flRef !== null && flRef !== void 0 && flRef.current)) {
        return;
      }

      if (autoscrollToTopThreshold.current === mvcp.autoscrollToTopThreshold && minIndexForVisible.current === mvcp.minIndexForVisible) {
        // Don't do anythinig if the values haven't changed
        return;
      }

      autoscrollToTopThreshold.current = mvcp.autoscrollToTopThreshold || -Number.MAX_SAFE_INTEGER;
      minIndexForVisible.current = mvcp.minIndexForVisible || 0;
      const viewTag = (0, _reactNative.findNodeHandle)(flRef.current);
      cleanupPromise = MvcpScrollViewManager.enableMaintainVisibleContentPosition(viewTag, autoscrollToTopThreshold.current, minIndexForVisible.current);
    };

    enableMaintainVisibleContentPosition();
    return () => {
      var _cleanupPromise;

      if (mvcp && autoscrollToTopThreshold.current === mvcp.autoscrollToTopThreshold && minIndexForVisible.current === mvcp.minIndexForVisible) {
        // Don't do anythinig if the values haven't changed
        return;
      }

      (_cleanupPromise = cleanupPromise) === null || _cleanupPromise === void 0 ? void 0 : _cleanupPromise.then(handle => {
        MvcpScrollViewManager.disableMaintainVisibleContentPosition(handle);
      });
    }; // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refReady, extraData, mvcp]);
};

exports.useMvcpTuner = useMvcpTuner;
//# sourceMappingURL=useMvcpTuner.js.map