/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import * as appInsights from 'applicationinsights';
export declare const CodedErrors: {
    Success: number;
    Unknown: number;
    UnsupportedReactNativeVersion: number;
    UserCancel: number;
    NoReactNativeFound: number;
    NoPackageJson: number;
    NoLatestReactNativeWindows: number;
    NoAutoMatchingReactNativeWindows: number;
    IncompatibleOptions: number;
    NoReactNativeDependencies: number;
    NoMatchingPackageVersion: number;
    NoSolution: number;
    NoPropertyInProject: number;
    CopyProjectTemplateNoSourcePath: number;
    CopyProjectTemplateNoDestPath: number;
    CopyProjectTemplateNoProjectName: number;
    MinSDKVersionNotMet: number;
    BadSDKVersionFormat: number;
    NoSDK: number;
    NoMSBuild: number;
    NoVSWhere: number;
    MSBuildError: number;
    NoAppPackage: number;
    NoAppxManifest: number;
    NoDevice: number;
    AppDidNotDeploy: number;
    InvalidDevicesOutput: number;
    RemoveOldAppVersionFailure: number;
    EnableDevModeFailure: number;
    InstallAppFailure: number;
    InstallAppDependenciesFailure: number;
    CheckNetIsolationFailure: number;
    InstallAppToDeviceFailure: number;
    UninstallAppOnDeviceFailure: number;
    DeployRecipeFailure: number;
    AppStartupFailure: number;
    NoWindowsConfig: number;
    IncompleteConfig: number;
    InvalidConfig: number;
    NeedAutolinking: number;
    AddProjectToSolution: number;
    Autolinking: number;
    NeedCodegen: number;
    InvalidCodegenConfig: number;
    NoTemplatesFound: number;
    NoDefaultTemplate: number;
    InvalidTemplateName: number;
    NoProjectName: number;
    InvalidProjectName: number;
};
export type CodedErrorType = keyof typeof CodedErrors;
/**
 * Represents an error whose message might contain user-originating content,
 * therefore when transmitting telemetry, only the type should be sent.
 * @param type a stable ID identifying the type of error.
 * @param message the error text. This should only be used for display to the user.
 * @param data any additional metadata that is safe to collect for telemetry purposes.
 */
export declare class CodedError extends Error {
    readonly type: CodedErrorType;
    readonly data?: Record<string, any> | undefined;
    constructor(type: CodedErrorType, message: string, data?: Record<string, any> | undefined);
}
/**
 * Tries to parse an error code out of an error message.
 * @param msg An error message to process.
 * @returns The parsed error code.
 */
export declare function tryGetErrorCode(msg: string): string | undefined;
/**
 * Sanitize an error message by anonymizing any paths that appear between quotes (''), brackets ([]), or double quotes ("").
 * @param msg The error message to sanitize.
 * @return The message with any paths anonymized.
 */
export declare function sanitizeErrorMessage(msg: string): string;
/**
 * Sanitizes an error stack frame.
 * @param frame
 */
export declare function sanitizeErrorStackFrame(frame: appInsights.Contracts.StackFrame): void;
