"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const versionUtils = __importStar(require("../utils/versionUtils"));
const path_1 = __importDefault(require("path"));
const semver_1 = __importDefault(require("semver"));
function expectValidVersion(version, expectSemVer) {
    expect(version).not.toBeNull();
    expect(version).toBeDefined();
    if (expectSemVer) {
        expect(semver_1.default.valid(version)).toBe(version);
    }
    else {
        version.split('.').forEach(s => {
            const tryParseInt = () => {
                parseInt(s, 10);
            };
            expect(tryParseInt).not.toThrow();
        });
    }
}
test('getNodeVersion() is valid', async () => {
    const version = await versionUtils.getNodeVersion();
    expectValidVersion(version, true);
});
test('getNpmVersion() is valid', async () => {
    const version = await versionUtils.getNpmVersion();
    if (version) {
        expectValidVersion(version, true);
    }
});
test('getYarnVersion() is valid', async () => {
    const version = await versionUtils.getYarnVersion();
    if (version) {
        expectValidVersion(version, true);
    }
});
test('getVisualStudioVersion() is valid', async () => {
    const version = await versionUtils.getVisualStudioVersion();
    expectValidVersion(version, false);
});
test('getVersionOfNpmPackage() of empty string is null', async () => {
    const version = await versionUtils.getVersionOfNpmPackage('');
    expect(version).toBeNull();
});
test('getVersionOfNpmPackage() of invalid package is null', async () => {
    const version = await versionUtils.getVersionOfNpmPackage('invalidpackage');
    expect(version).toBeNull();
});
test('getVersionOfNpmPackage() of valid package is valid', async () => {
    const version = await versionUtils.getVersionOfNpmPackage('jest');
    expectValidVersion(version, true);
});
test('getVersionsOfNuGetPackages() of valid package in packages.config is valid', async () => {
    const projectFile = path_1.default.resolve(__dirname, 'projects/UsesPackagesConfig/UsesPackagesConfig.vcxproj');
    const versions = await versionUtils.getVersionsOfNuGetPackages(projectFile, [
        'Microsoft.Windows.CppWinRT',
    ]);
    expect(versions).not.toBeNull();
    expectValidVersion(versions['Microsoft.Windows.CppWinRT'], false);
});
test('getVersionsOfNuGetPackages() of invalid package in packages.config is invalid', async () => {
    const projectFile = path_1.default.resolve(__dirname, 'projects/UsesPackagesConfig/UsesPackagesConfig.vcxproj');
    const versions = await versionUtils.getVersionsOfNuGetPackages(projectFile, [
        'Invalid.Package',
    ]);
    expect(versions).toStrictEqual({});
});
test('getVersionsOfNuGetPackages() of valid package in project is valid', async () => {
    const projectFile = path_1.default.resolve(__dirname, 'projects/UsesPackageReference/UsesPackageReference.csproj');
    const versions = await versionUtils.getVersionsOfNuGetPackages(projectFile, [
        'Microsoft.NETCore.UniversalWindowsPlatform',
    ]);
    expect(versions).not.toBeNull();
    expectValidVersion(versions['Microsoft.NETCore.UniversalWindowsPlatform'], false);
});
test('getVersionsOfNuGetPackages() of invalid package in project is invalid', async () => {
    const projectFile = path_1.default.resolve(__dirname, 'projects/UsesPackageReference/UsesPackageReference.csproj');
    const versions = await versionUtils.getVersionsOfNuGetPackages(projectFile, [
        'Invalid.Package',
    ]);
    expect(versions).toStrictEqual({});
});
//# sourceMappingURL=versionUtils.test.js.map