/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * @format
 */
import * as appInsights from 'applicationinsights';
import { Telemetry, TelemetryOptions } from '../telemetry';
export declare class TelemetryTest extends Telemetry {
    protected static hasTestTelemetryProviders: boolean;
    protected static testTelemetryProvidersRan: boolean;
    /** Run at the beginning of each test. */
    static startTest(options?: Partial<TelemetryOptions>): Promise<void>;
    /** Run at the end of each test where telemetry was fired. */
    static endTest(finalCallback?: () => void): void;
    /** Sets that the telemetry provider has run. */
    static setTestTelemetryProvidersRan(): void;
    /** Retrieves the value of a common property.*/
    static getCommonProperty(key: string): string | undefined;
    /** Retrieves the version of the specified tool/package. */
    static getVersion(key: string): string | null;
    /** Retrieves the value of the preserveErrorMessages option. */
    static getPreserveErrorMessages(): boolean;
    /** Adds a telemetry processor, usually for verifying the envelope. */
    static addTelemetryProcessor(telemetryProcessor: (envelope: appInsights.Contracts.EnvelopeTelemetry, contextObjects?: {
        [name: string]: any;
    }) => boolean): void;
}
