/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import { Config, CommandOption } from '@react-native-community/cli-types';
import { CommanderOptionsType, OptionSanitizer } from '@react-native-windows/telemetry';
/**
 * Calculates a the default values of a given react-native CLI command's options.
 * @param config Config passed from react-native CLI.
 * @param commandOptions The options definition for the command.
 * @returns The default options for the command.
 */
export declare function getDefaultOptions(config: Config, commandOptions: CommandOption[]): CommanderOptionsType;
/**
 * Sets up and starts the telemetry gathering for the CLI command.
 * @param commandName The name of the CLI command.
 * @param config Config passed from react-native CLI.
 * @param options Options passed from react-native CLI.
 * @param defaultOptions Default options for the command.
 * @param optionSanitizer Function to sanitize the option values for telemetry.
 */
export declare function startTelemetrySession(commandName: string, config: Config, options: CommanderOptionsType, defaultOptions: CommanderOptionsType, optionSanitizer: OptionSanitizer): Promise<void>;
/**
 * Ends the gathering of telemetry for the CLI command.
 * @param error The error (if any) thrown during the command.
 * @param getExtraProps Function to get any extra command-specific telemetry properties.
 */
export declare function endTelemetrySession(error?: Error, getExtraProps?: () => Promise<Record<string, any>>): Promise<void>;
