/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import Version from './version';
import { BuildArch, BuildConfig } from '../commands/runWindows/runWindowsOptions';
export default class MSBuildTools {
    readonly version: string;
    readonly installationPath: string;
    readonly installationVersion: string;
    /**
     * @param version is something like 17.0 for 2022
     * @param installationPath  Path to installation root
     * @param installationVersion is the full version e.g. 17.3.32929.385
     */
    constructor(version: string, installationPath: string, installationVersion: string);
    /**
     * @returns directory where x86 msbuild can be found
     */
    msbuildPath(): string;
    cleanProject(slnFile: string): void;
    restorePackageConfigs(slnFile: any, buildArch: BuildArch, buildType: BuildConfig): Promise<void>;
    buildProject(slnFile: string, buildType: BuildConfig, buildArch: BuildArch, msBuildProps: Record<string, string>, verbose: boolean, target: 'build' | 'deploy', buildLogDirectory: string | undefined, singleproc?: boolean): Promise<void>;
    static findAvailableVersion(buildArch: BuildArch, verbose: boolean, prerelease?: boolean): MSBuildTools;
    static getAllAvailableUAPVersions(): Version[];
    evaluateMSBuildProperties(solutionFile: string, projectFile: string, propertyNames?: string[], extraMsBuildProps?: Record<string, string>): Record<string, string>;
}
