"use strict";
/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 * @format
 */
Object.defineProperty(exports, "__esModule", { value: true });
const telemetry_1 = require("@react-native-windows/telemetry");
const initWindowsOptions_1 = require("../commands/initWindows/initWindowsOptions");
function validateOptionName(name, optionName) {
    // Do not add a default case here. Every item must explicitly return true
    switch (optionName) {
        case 'logging':
        case 'template':
        case 'name':
        case 'namespace':
        case 'overwrite':
        case 'telemetry':
            return true;
    }
    throw new Error(`Unable to find ${optionName} to match '${name}' in InitOptions.`);
}
test('initOptions - validate options', () => {
    for (const commandOption of initWindowsOptions_1.initOptions) {
        // Validate names
        expect(commandOption.name).not.toBeNull();
        expect(commandOption.name.startsWith('--')).toBe(true);
        expect(commandOption.name).toBe(commandOption.name.trim());
        // Validate defaults
        if (!commandOption.name.endsWith(' [string]') &&
            !commandOption.name.endsWith(' [number]')) {
            // Commander ignores defaults for flags, so leave undefined to prevent confusion
            expect(commandOption.default).toBeUndefined();
        }
        // Validate description
        expect(commandOption.description).not.toBeNull();
        expect(commandOption.description).toBe(commandOption.description.trim());
        // Validate all command options are present in InitOptions
        const optionName = (0, telemetry_1.commanderNameToOptionName)(commandOption.name);
        expect(validateOptionName(commandOption.name, optionName)).toBe(true);
    }
});
//# sourceMappingURL=initWindows.test.js.map