/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import { Ora } from 'ora';
import { Command, Config } from '@react-native-community/cli-types';
import { CodeGenOptions } from './codegenWindowsOptions';
export declare class CodeGenWindows {
    readonly root: string;
    readonly options: CodeGenOptions;
    private changesNecessary;
    areChangesNeeded(): boolean;
    constructor(root: string, options: CodeGenOptions);
    run(spinner: Ora): Promise<void>;
}
/**
 * Performs codegen for RNW native modules and apps.
 * @param args Unprocessed args passed from react-native CLI.
 * @param config Config passed from react-native CLI.
 * @param options Options passed from react-native CLI.
 */
export declare function codegenWindowsInternal(args: string[], config: Config, options: CodeGenOptions): Promise<void>;
/**
 * Performs codegen for RNW native modules.
 */
export declare const codegenCommand: Command;
