/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import { Ora } from 'ora';
import { Command, Config, DependencyConfig, ProjectConfig } from '@react-native-community/cli-types';
import { AutoLinkOptions } from './autolinkWindowsOptions';
import { WindowsProjectConfig } from '../config/projectConfig';
export declare class AutoLinkWindows {
    readonly projectConfig: ProjectConfig;
    readonly dependenciesConfig: {
        [key: string]: DependencyConfig;
    };
    readonly options: AutoLinkOptions;
    private changesNecessary;
    protected windowsAppConfig: WindowsProjectConfig;
    areChangesNeeded(): boolean;
    private getWindowsConfig;
    private getSolutionFile;
    constructor(projectConfig: ProjectConfig, dependenciesConfig: {
        [key: string]: DependencyConfig;
    }, options: AutoLinkOptions);
    run(spinner: Ora): Promise<void>;
    /**
     * Handles the --proj command-line option by consuming its value into the windowsAppConfig
     */
    fixUpForProjOption(): void;
    /**
     * Handles the --sln command-line option by consuming its value into the windowsAppConfig
     */
    fixUpForSlnOption(): void;
    /** Validates the all of the required app (solution) properties are present and valid */
    validateRequiredAppProperties(): void;
    /** @return the full path to the project file (.vcxproj or .csproj) */
    private getProjectFile;
    /** Validates that all of the required app _project_ properties are present and valid */
    validateRequiredProjectProperties(): void;
    private generateCppAutolinking;
    getCppReplacements(): {
        cppPackageProviders: string;
        cppIncludes: string;
    };
    private generateCSAutolinking;
    getCsReplacements(): {
        csUsingNamespaces: string;
        csReactPackageProviders: string;
    };
    /** Cache of dependencies */
    private windowsDependencies;
    private getWindowsDependencies;
    /**
     * Updates the target file with the expected contents if it's different.
     * @param filePath Path to the target file to update.
     * @param expectedContents The expected contents of the file.
     * @return Whether any changes were necessary.
     */
    protected updateFile(filePath: string, expectedContents: string): Promise<boolean>;
    private generateAutolinkTargets;
    private generateAutolinkProps;
    private getCSModules;
    private updateSolution;
    protected getExperimentalFeaturesPropsXml(): {
        path: string;
        content: Document;
    } | undefined;
    ensureXAMLDialect(): Promise<boolean>;
    protected getPackagesConfigXml(): {
        path: string;
        content: Document;
    } | undefined;
    private updatePackagesConfigXAMLDialect;
    private updatePackagesConfig;
    /** @return The CLI command to invoke autolink-windows independently */
    getAutolinkWindowsCommand(): string;
}
/**
 * Performs auto-linking for RNW native modules and apps.
 * @param args Unprocessed args passed from react-native CLI.
 * @param config Config passed from react-native CLI.
 * @param options Options passed from react-native CLI.
 */
export declare function autolinkWindowsInternal(args: string[], config: Config, options: AutoLinkOptions): Promise<void>;
/**
 * Performs auto-linking for RNW native modules and apps.
 */
export declare const autolinkCommand: Command;
