(function (win, doc, cfg) {
    var locn = win.location;
    var helpLink = "https://go.microsoft.com/fwlink/?linkid=2128109";
    var scriptText = "script";
    var strInstrumentationKey = "instrumentationKey";
    var strIngestionendpoint = "ingestionendpoint";
    var strDisableExceptionTracking = "disableExceptionTracking";
    var strAiDevice = "ai.device.";
    var strAiOperationName = "ai.operation.name";
    var strAiSdkVersion = "ai.internal.sdkVersion";
    var strToLowerCase = "toLowerCase";
    var strConStringIKey = strInstrumentationKey[strToLowerCase]();
    var strEmpty = "";
    var strUndefined = "undefined";
    var strCrossOrigin = "crossOrigin";
    var strPostMethod = "POST";
    var sdkInstanceName = "appInsightsSDK";
    var aiName = cfg.name || "appInsights";
    if (cfg.name || win[sdkInstanceName]) {
        win[sdkInstanceName] = aiName;
    }
    var aiSdk = win[aiName] || (function (aiConfig) {
        var loadFailed = false;
        var handled = false;
        var appInsights = {
            initialize: true,
            queue: [],
            sv: "7",
            version: 2.0,
            config: aiConfig
        };
        function isIE() {
            var nav = navigator;
            if (nav) {
                var userAgent = (nav.userAgent || "").toLowerCase();
                return (userAgent.indexOf("msie") !== -1 || userAgent.indexOf("trident/") !== -1);
            }
            return false;
        }
        function _parseConnectionString() {
            var fields = {};
            var connectionString = aiConfig.connectionString;
            if (connectionString) {
                var kvPairs = connectionString.split(";");
                for (var lp = 0; lp < kvPairs.length; lp++) {
                    var kvParts = kvPairs[lp].split("=");
                    if (kvParts.length === 2) {
                        fields[kvParts[0][strToLowerCase]()] = kvParts[1];
                    }
                }
            }
            if (!fields[strIngestionendpoint]) {
                var endpointSuffix = fields.endpointsuffix;
                var fLocation = endpointSuffix ? fields.location : null;
                fields[strIngestionendpoint] = "https://" + (fLocation ? fLocation + "." : strEmpty) + "dc." + (endpointSuffix || "services.visualstudio.com");
            }
            return fields;
        }
        function _sendEvents(evts, endpointUrl) {
            if (JSON) {
                var sender = win.fetch;
                if (sender && !cfg.useXhr) {
                    sender(endpointUrl, { method: strPostMethod, body: JSON.stringify(evts), mode: "cors" });
                }
                else if (XMLHttpRequest) {
                    var xhr = new XMLHttpRequest();
                    xhr.open(strPostMethod, endpointUrl);
                    xhr.setRequestHeader("Content-type", "application/json");
                    xhr.send(JSON.stringify(evts));
                }
            }
        }
        function _reportFailure(targetSrc) {
            if (cfg.dle === true) {
                return;
            }
            var conString = _parseConnectionString();
            var iKey = conString[strConStringIKey] || aiConfig[strInstrumentationKey] || strEmpty;
            var ingest = conString[strIngestionendpoint];
            if (ingest && ingest.slice(-1) === "/") {
                ingest = ingest.slice(0, -1);
            }
            var endpointUrl = ingest ? ingest + "/v2/track" : aiConfig.endpointUrl;
            var message = "SDK LOAD Failure: Failed to load Application Insights SDK script (See stack for details)";
            var evts = [];
            evts.push(_createException(iKey, message, targetSrc, endpointUrl));
            evts.push(_createInternal(iKey, message, targetSrc, endpointUrl));
            _sendEvents(evts, endpointUrl);
        }
        function _getTime() {
            var date = new Date();
            function pad(num) {
                var r = strEmpty + num;
                if (r.length === 1) {
                    r = "0" + r;
                }
                return r;
            }
            return date.getUTCFullYear()
                + "-" + pad(date.getUTCMonth() + 1)
                + "-" + pad(date.getUTCDate())
                + "T" + pad(date.getUTCHours())
                + ":" + pad(date.getUTCMinutes())
                + ":" + pad(date.getUTCSeconds())
                + "." + String((date.getUTCMilliseconds() / 1000).toFixed(3)).slice(2, 5)
                + "Z";
        }
        function _createEnvelope(iKey, theType) {
            var tags = {};
            var type = "Browser";
            tags[strAiDevice + "id"] = type[strToLowerCase]();
            tags[strAiDevice + "type"] = type;
            tags[strAiOperationName] = locn && locn.pathname || "_unknown_";
            tags[strAiSdkVersion] = "javascript:snippet_" + (appInsights.sv || appInsights.version);
            var envelope = {
                time: _getTime(),
                iKey: iKey,
                name: "Microsoft.ApplicationInsights." + iKey.replace(/-/g, strEmpty) + "." + theType,
                sampleRate: 100,
                tags: tags,
                data: {
                    baseData: {
                        ver: 2
                    }
                },
                ver: 4.0,
                seq: "1",
                aiDataContract: undefined
            };
            return envelope;
        }
        function _createInternal(iKey, message, targetSrc, endpointUrl) {
            var envelope = _createEnvelope(iKey, "Message");
            var data = envelope.data;
            data.baseType = "MessageData";
            var baseData = data.baseData;
            baseData.message = "AI (Internal): 99 message:\"" + (message + " (" + targetSrc + ")").replace(/\"/g, strEmpty) + "\"";
            baseData.properties = {
                endpoint: endpointUrl
            };
            return envelope;
        }
        function _createException(iKey, message, targetSrc, endpointUrl) {
            var envelope = _createEnvelope(iKey, "Exception");
            var data = envelope.data;
            data.baseType = "ExceptionData";
            data.baseData.exceptions = [{
                    typeName: "SDKLoadFailed",
                    message: message.replace(/\./g, "-"),
                    hasFullStack: false,
                    stack: message + "\nSnippet failed to load [" + targetSrc + "] -- Telemetry is disabled\nHelp Link: " + helpLink + "\nHost: " + (locn && locn.pathname || "_unknown_") + "\nEndpoint: " + endpointUrl,
                    parsedStack: []
                }];
            return envelope;
        }
        var domainRetryIndex = -1;
        var domainRetryCount = 0;
        var domains = [
            "js.monitor.azure.com",
            "js.cdn.applicationinsights.io",
            "js.cdn.monitor.azure.com",
            "js0.cdn.applicationinsights.io",
            "js0.cdn.monitor.azure.com",
            "js2.cdn.applicationinsights.io",
            "js2.cdn.monitor.azure.com",
            "az416426.vo.msecnd.net"
        ];
        var targetSrc = aiConfig["url"] || cfg.src;
        if (targetSrc) {
            if (isIE() && targetSrc.indexOf("ai.3") !== -1) {
                targetSrc = targetSrc.replace(/(\/)(ai\.3\.)([^\d]*)$/, function (_all, g1, g2) {
                    return g1 + "ai.2" + g2;
                });
            }
            if (cfg.cr !== false) {
                for (var i = 0; i < domains.length; i++) {
                    if (targetSrc.indexOf(domains[i]) > 0) {
                        domainRetryIndex = i;
                        break;
                    }
                }
            }
            var _handleError_1 = function (evt) {
                appInsights.queue = [];
                if (!handled) {
                    if (domainRetryIndex >= 0 && domainRetryCount + 1 < domains.length) {
                        var nextIdx_1 = (domainRetryIndex + domainRetryCount + 1) % domains.length;
                        _createScript_1(targetSrc.replace(/^(.*\/\/)([\w\.]*)(\/.*)$/, function (_all, http, domain, qs) {
                            return http + domains[nextIdx_1] + qs;
                        }));
                        domainRetryCount += 1;
                    }
                    else {
                        handled = true;
                        loadFailed = true;
                        _reportFailure(targetSrc);
                    }
                }
            };
            var _handleLoad_1 = function (evt, isAbort) {
                if (!handled) {
                    setTimeout(function () {
                        if (isAbort || !appInsights.core) {
                            _handleError_1();
                        }
                    }, 500);
                }
                loadFailed = false;
            };
            var _createScript_1 = function (src) {
                var scriptElement = doc.createElement(scriptText);
                scriptElement["src"] = src;
                var crossOrigin = cfg[strCrossOrigin];
                if ((crossOrigin || crossOrigin === "") && scriptElement[strCrossOrigin] != strUndefined) {
                    scriptElement[strCrossOrigin] = crossOrigin;
                }
                scriptElement.onload = _handleLoad_1;
                scriptElement.onerror = _handleError_1;
                scriptElement["onreadystatechange"] = function (evt, isAbort) {
                    if (scriptElement["readyState"] === "loaded" || scriptElement["readyState"] === "complete") {
                        _handleLoad_1(evt, isAbort);
                    }
                };
                if (cfg.ld && cfg.ld < 0) {
                    var headNode = doc.getElementsByTagName("head")[0];
                    headNode.appendChild(scriptElement);
                }
                else {
                    setTimeout(function () {
                        doc.getElementsByTagName(scriptText)[0].parentNode.appendChild(scriptElement);
                    }, cfg.ld || 0);
                }
                return scriptElement;
            };
            _createScript_1(targetSrc);
        }
        try {
            appInsights.cookie = doc.cookie;
        }
        catch (e) {
        }
        function _createMethods(methods) {
            while (methods.length) {
                (function (name) {
                    appInsights[name] = function () {
                        var originalArguments = arguments;
                        if (!loadFailed) {
                            appInsights.queue.push(function () {
                                appInsights[name].apply(appInsights, originalArguments);
                            });
                        }
                    };
                })(methods.pop());
            }
        }
        var track = "track";
        var trackPage = "TrackPage";
        var trackEvent = "TrackEvent";
        _createMethods([track + "Event",
            track + "PageView",
            track + "Exception",
            track + "Trace",
            track + "DependencyData",
            track + "Metric",
            track + "PageViewPerformance",
            "start" + trackPage,
            "stop" + trackPage,
            "start" + trackEvent,
            "stop" + trackEvent,
            "addTelemetryInitializer",
            "setAuthenticatedUserContext",
            "clearAuthenticatedUserContext",
            "flush"]);
        appInsights["SeverityLevel"] = {
            Verbose: 0,
            Information: 1,
            Warning: 2,
            Error: 3,
            Critical: 4
        };
        var analyticsCfg = ((aiConfig.extensionConfig || {}).ApplicationInsightsAnalytics || {});
        if (!(aiConfig[strDisableExceptionTracking] === true || analyticsCfg[strDisableExceptionTracking] === true)) {
            var method_1 = "onerror";
            _createMethods(["_" + method_1]);
            var originalOnError_1 = win[method_1];
            win[method_1] = function (message, url, lineNumber, columnNumber, error) {
                var handled = originalOnError_1 && originalOnError_1(message, url, lineNumber, columnNumber, error);
                if (handled !== true) {
                    appInsights["_" + method_1]({
                        message: message,
                        url: url,
                        lineNumber: lineNumber,
                        columnNumber: columnNumber,
                        error: error,
                        evt: win.event
                    });
                }
                return handled;
            };
            aiConfig["autoExceptionInstrumented"] = true;
        }
        return appInsights;
    })(cfg.cfg);
    win[aiName] = aiSdk;
    function _onInit() {
        if (cfg.onInit) {
            cfg.onInit(aiSdk);
        }
    }
    if (aiSdk.queue && aiSdk.queue.length === 0) {
        aiSdk.queue.push(_onInit);
        aiSdk.trackPageView({});
    }
    else {
        _onInit();
    }
})(window, document, {
    src: "https://js.monitor.azure.com/scripts/b/ai.3.gbl.min.js",
    // name: "appInsights", // Global SDK Instance name defaults to "appInsights" when not supplied
    // ld: 0, // Defines the load delay (in ms) before attempting to load the sdk. -1 = block page load and add to head. (default) = 0ms load after timeout,
    // useXhr: 1, // Use XHR instead of fetch to report failures (if available),
    // dle: true, // Prevent the SDK from reporting load failure log
    crossOrigin: "anonymous", // When supplied this will add the provided value as the cross origin attribute on the script tag
    // onInit: null, // Once the application insights instance has loaded and initialized this callback function will be called with 1 argument -- the sdk instance (DO NOT ADD anything to the sdk.queue -- As they won't get called)
    cfg: { // Application Insights Configuration
        connectionString: "YOUR_CONNECTION_STRING"
    }
});
//# sourceMappingURL=snippet.js.map
