import { createMemoizedNumberFormat } from '@formatjs/ecma402-abstract';
import { units } from './units.generated';
function isSupported(unit, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var formatter = createMemoizedNumberFormat(locale, { style: 'unit', unit: unit });
        return formatter.resolvedOptions().unit === unit;
    }
    catch (_err) { }
    return false;
}
export function getSupportedUnits(locale) {
    return units.filter(function (unit) { return isSupported(unit, locale); });
}
