import { createMemoizedDateTimeFormat } from '@formatjs/ecma402-abstract';
import { timezones } from './timezones.generated';
function isSupported(timeZone, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var formatter = createMemoizedDateTimeFormat(locale, { timeZone: timeZone });
        return formatter.resolvedOptions().timeZone === timeZone;
    }
    catch (_err) { }
    return false;
}
export function getSupportedTimeZones(locale) {
    return timezones.filter(function (timezone) { return isSupported(timezone, locale); });
}
