import { createMemoizedNumberFormat } from '@formatjs/ecma402-abstract';
import { numberingSystemNames } from './numbering-systems.generated';
function isSupportedNumberingSystem(system, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var numberFormat = createMemoizedNumberFormat("".concat(locale, "-u-nu-").concat(system));
        var options = numberFormat.resolvedOptions().numberingSystem;
        if ((options === system && system === 'latn') ||
            numberFormat.format(123) !== '123') {
            return true;
        }
    }
    catch (_err) { }
    return false;
}
export function getSupportedNumberingSystems(locale) {
    return numberingSystemNames.filter(function (numberingSystemName) {
        return isSupportedNumberingSystem(numberingSystemName, locale);
    });
}
