import { DateTimeFormatLocaleInternalData, DateTimeFormat as IDateTimeFormat, UnpackedZoneData } from '@formatjs/ecma402-abstract';
import { PackedData, RawDateTimeLocaleData } from './types';
export interface DateTimeFormatConstructor {
    new (locales?: string | string[], options?: Intl.DateTimeFormatOptions): IDateTimeFormat;
    (locales?: string | string[], options?: Intl.DateTimeFormatOptions): IDateTimeFormat;
    __addLocaleData(...data: RawDateTimeLocaleData[]): void;
    supportedLocalesOf(locales: string | string[], options?: Pick<Intl.DateTimeFormatOptions, 'localeMatcher'>): string[];
    getDefaultLocale(): string;
    relevantExtensionKeys: string[];
    __defaultLocale: string;
    __defaultTimeZone: string;
    __setDefaultTimeZone(tz: string): void;
    getDefaultTimeZone(): string;
    localeData: Record<string, DateTimeFormatLocaleInternalData>;
    availableLocales: Set<string>;
    polyfilled: boolean;
    tzData: Record<string, UnpackedZoneData[]>;
    __addTZData(d: PackedData): void;
}
export declare const DateTimeFormat: DateTimeFormatConstructor;
