// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import * as React from 'react';
import Svg, {
    G,
    Path,
    Ellipse,
} from 'react-native-svg';

import type {StyleProp, ViewStyle} from 'react-native';

type Props = {
    theme: Theme;
    styles: StyleProp<ViewStyle>;
};

const ChatSvg = ({theme, styles}: Props) => {
    return (
        <Svg
            width={263}
            height={212}
            viewBox='0 0 263 212'
            fill='none'
            style={styles}
        >
            <G clipPath='url(#clip0_1023_92018)'>
                <Path
                    d='M176.396 29c-3.441 5.745-14.534 1.149-16.633 12.065 4.083 0 19.145 2.08 19.145 2.08L176.396 29z'
                    fill='#4A2407'
                />
                <Path
                    d='M159.269 86.21c-4.852 8.63-44.21 25.658-34.827 69.563 6.642 31.104 21.796 43.514 18.021 48.707-2.799 3.792-5.001 8.411 1.652 2.953 8.03-6.561 10.887-2.206 5.679-18.017-4.967-15.052-9.338-55.153 15.474-69.378 24.813-14.225 32.912-21.338 20.649-38.803-4.486-6.412-26.648 4.975-26.648 4.975z'
                    fill='#AD831F'
                />
                <Path
                    d='M139.516 193.726c.826-.23 7.846-2.459 10.507-3.585 4.887 14.937 1.974 10.835-5.907 17.293-6.654 5.457-4.451.839-1.652-2.953 1.514-2.114-.046-5.447-2.948-10.755z'
                    fill='#1C58D9'
                />
                <Path
                    d='M187.752 42.18l.631-12.766 1.709-4.71c-1.056-4.689-3.774-6.895-5.3-7.309-3.441-.85-5.391-.988-7.273.483-1.032.884-2.627 4.93-3.315 8.1-.367 1.712-1.147 3.08 0 4.137a19.554 19.554 0 002.489 1.666l.184 8.043 10.875 2.356z'
                    fill='#AD831F'
                />
                <Path
                    d='M176.396 21.118a14.637 14.637 0 00-3.109 2.045c-.39 1.149 2.627 2.298 2.627 2.298l.482-4.343z'
                    fill='#AD831F'
                />
                <Path
                    d='M180.365 32.838a8.292 8.292 0 01-3.625-1.023c-.402-.253.734.747 1.147.977a3.7 3.7 0 001.789.666c.482 0 1.17-.586.689-.62z'
                    fill='#8B6918'
                />
                <Path
                    d='M202.768 90.703c2.294 31.805 3.085 74.469 31.718 81.581 28.632 7.113 27.531 3.597 27.531 14.26s-2.214 9.088-3.522 2.298c-1.675-8.779-32.957 6.894-54.179-10.617-21.222-17.512-30.181-51.362-33.416-86.086-2.271-24.59 31.868-1.436 31.868-1.436z'
                    fill='#AD831F'
                />
                <Path
                    d='M250.271 175.824c12.389 2.631 11.758 2.551 11.758 10.674 0 10.663-2.214 9.089-3.522 2.298-.585-3.045-4.738-3.148-10.794-2.711a49.014 49.014 0 002.558-10.261z'
                    fill='#1C58D9'
                />
                <Path
                    d='M104.781 44.834c.665-1.15 6.217-1.333 12.744 3.976 6.527 5.308 17.138 11.915 28.942-2.448 10.588-12.903 17.632-8.043 28.357-7.618 3.809.483 19.18 2.448 23.103 2.804 5.736-.104 15.521 2.631 22.289-13.168 2.593-6.055 5.277-14.765 9.005-20.683 2.558-4.044 5.07-6.515 7.445-7.503 1.755-.724.78.667-.574 2.677-.906 1.368.104 1.207-.401 2.942-.298 1.011-.436 1.609-.769 2.482a20.454 20.454 0 00-.711 2.401c-.149.62-.298 1.276-.424 1.976l-.104.483c-1.376 7.56-2.122 18.649-3.154 23.107-3.602 15.34-11.471 24.394-25.845 27.577a257.068 257.068 0 01-.447 7.17c-2.581 36.195 1.089 26.428-22.404 26.428s-29.745 14.11-26.212-6.124c1.664-9.48 1.147-20.5 2.971-31.737-3.579 2.23-9.36 6.802-15.165 8.239-18.067 4.435-34.735-19.178-34.895-20.683-.253-2.321-4.405-1.114-3.751-2.298z'
                    fill='#AD831F'
                />
                <Path
                    d='M153.533 64.874c2.398-1.506 3.384-4.263 5.059-5.298a127.57 127.57 0 00-1.342 12.938c-.195 3.068-.344 6.09-.551 9.02a95.15 95.15 0 01-1.078 9.79c-3.533 20.223 2.719 6.136 26.212 6.102 20.568 0 20.316 7.503 21.669-14.938v-.15c.069-.964.127-1.976.195-3.044.149-2.46.322-5.205.54-8.296.183-2.62.344-4.999.447-7.17 6.298-1.402 11.356-1.861 15.36-5.573-2.065-5.94-4.715-13.696-8.672-18.626-4.233 2.448-8.546 2.034-11.919 1.92h-1.526l-2.03-.208c-1.48-.16-3.442-.39-5.518-.643-1.147 5.883-10.255 5.01-13.261 2.953A12.146 12.146 0 01173 38.629a81.189 81.189 0 01-3.671-.424c-1.181-.161-2.214-.31-3.28-.437-6.459-.782-12.148-.46-19.582 8.594-.459.563-.918 1.07-1.365 1.563a149.59 149.59 0 008.431 16.949z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M153.533 64.874c2.398-1.506 3.384-4.263 5.059-5.298a127.57 127.57 0 00-1.342 12.938c-.195 3.068-.344 6.09-.551 9.02a95.15 95.15 0 01-1.078 9.79c-3.533 20.223 2.719 6.136 26.212 6.102 20.568 0 20.316 7.503 21.669-14.938v-.15c.069-.964.127-1.976.195-3.044.149-2.46.322-5.205.54-8.296.183-2.62.344-4.999.447-7.17 6.298-1.402 11.356-1.861 15.36-5.573-2.065-5.94-4.715-13.696-8.672-18.626-4.233 2.448-8.546 2.034-11.919 1.92h-1.526l-2.03-.208c-1.48-.16-3.442-.39-5.518-.643-1.147 5.883-10.255 5.01-13.261 2.953A12.146 12.146 0 01173 38.629a81.189 81.189 0 01-3.671-.424c-1.181-.161-2.214-.31-3.28-.437-6.459-.782-12.148-.46-19.582 8.594-.459.563-.918 1.07-1.365 1.563a149.59 149.59 0 008.431 16.949z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M153.533 64.874c2.398-1.506 3.384-4.263 5.059-5.298a127.57 127.57 0 00-1.342 12.938c-.195 3.068-.344 6.09-.551 9.02a95.15 95.15 0 01-1.078 9.79c-3.533 20.223 2.719 6.136 26.212 6.102 20.568 0 20.316 7.503 21.669-14.938v-.15c.069-.964.127-1.976.195-3.044.149-2.46.322-5.205.54-8.296.183-2.62.344-4.999.447-7.17 6.298-1.402 11.356-1.861 15.36-5.573-2.065-5.94-4.715-13.696-8.672-18.626-4.233 2.448-8.546 2.034-11.919 1.92h-1.526l-2.03-.208c-1.48-.16-3.442-.39-5.518-.643-1.147 5.883-10.255 5.01-13.261 2.953A12.146 12.146 0 01173 38.629a81.189 81.189 0 01-3.671-.424c-1.181-.161-2.214-.31-3.28-.437-6.459-.782-12.148-.46-19.582 8.594-.459.563-.918 1.07-1.365 1.563a149.59 149.59 0 008.431 16.949z'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.08}
                />
                <Path
                    d='M136.946 107.295a105.804 105.804 0 0015.222 17.178l.493.437a195.036 195.036 0 003.442 2.987c.462-.547.973-1.05 1.525-1.505l.505-.425c1.858-1.563 4.52-3.447 7.17-5.32 3.728-2.574 7.41-4.952 8.695-5.745.94 5.194 2.053 10.341 3.361 15.225l.172.654c.218.77.424 1.54.642 2.298a110.202 110.202 0 0025.673-3.573l.643-.184 1.319-.402c.15-.048.303-.086.459-.115-.161-1-.31-2.103-.459-3.298 0-.229 0-.448-.081-.678-1.583-13.65-2.409-38.251-2.225-42.296v-.149a15.072 15.072 0 01-1.411-1.31c-.191-.2-.386-.406-.585-.62-4.279-4.803-6.39-11.778-7.617-16.03.425-9.399 1.296-14.385 5.564-22.83-.539 0-2.719-.15-3.556-.242a61.53 61.53 0 00-5.002 19.821c-8.03-1.46-16.06-2.758-24.09-3.999a112.698 112.698 0 012.467-18.959c-1.147-.15-2.214-.31-3.281-.436a95.116 95.116 0 00-2.18 21.463c-.459 1.15-1.365 4.597-2.03 5.86a74.988 74.988 0 01-4.589 7.435c-.195 3.068-.344 6.09-.55 9.02-.207 2.93-.471 5.745-.884 8.491-3.98 3.585-10.415 8.273-16.541 14.696-.149.161-.31.322-.459.494-.574.644-1.193 1.333-1.812 2.057z'
                    fill={theme.buttonBg}
                />
                <Path
                    d='M187.856 88.416a4.124 4.124 0 002.535-.643c.998-.735 1.377-2.126 1.652-4.125.688-4.884.355-5.297-1.457-7.595-.585-.736-1.319-1.655-2.225-3a23.7 23.7 0 01-1.985-3.446c-1.147-2.436-1.617-2.988-7.468-4.125-9.464-1.839-10.198-1.287-12.951 2.367-.505.666-1.067 1.413-1.778 2.298-4.21 4.986-4.244 5.619-4.37 7.963 0 .632-.081 1.413-.218 2.447-.207 1.47-.218 2.447.332 3.171.861 1.15 2.845 1.368 7.617 1.954 1.962.241 4.405.54 7.399.988 2.294.345 4.302.666 6.046.954 2.269.42 4.565.685 6.871.793zm-9.017-22.67v.322c5.736 1.149 5.943 1.574 6.998 3.768a25.23 25.23 0 002.03 3.585 35.16 35.16 0 002.295 3.045c1.755 2.207 1.973 2.494 1.33 7.09-.298 2.16-.677 3.16-1.388 3.689-1.239.907-3.797.482-8.913-.368-1.744-.288-3.717-.61-6.057-.954-3.005-.448-5.449-.747-7.41-.988-4.314-.529-6.482-.804-7.17-1.7-.413-.54-.39-1.391-.206-2.678.149-1.057.183-1.861.218-2.505.126-2.172.149-2.746 4.221-7.572a41.556 41.556 0 001.79-2.298c2.523-3.332 2.982-3.941 12.308-2.126l-.046-.31z'
                    fill='#2D3039'
                />
                <Path
                    d='M184.299 68.825c.239.499.515.98.826 1.437.229.356-.333.689-.574.333-.31-.458-.587-.938-.826-1.436-.183-.38.402-.713.574-.334zM186.112 72.135c.39.609.78 1.149 1.204 1.77.241.344-.321.677-.573.333-.413-.575-.815-1.15-1.147-1.77-.322-.356.298-.69.516-.333zM188.979 76.041c.3.408.63.792.987 1.15.31.287-.161.757-.47.459-.36-.355-.69-.74-.987-1.15-.252-.333.207-.804.47-.459zM190.287 80.408c0-.425.631-.425.654 0 .034.44.034.881 0 1.321 0 .425-.688.425-.654 0 .035-.44.035-.882 0-1.321zM189.702 83.958c.069-.425.711-.24.631.173-.08.414-.184 1.149-.287 1.712-.103.563-.7.241-.631-.184l.287-1.7zM184.54 85.05c.838.23 1.694.392 2.558.482.413 0 .425.701 0 .655a16.798 16.798 0 01-2.73-.494.332.332 0 01-.075-.605.331.331 0 01.247-.038zM178.128 84.314c.838.054 1.673.154 2.5.3.425.068.241.7-.172.631a22.534 22.534 0 00-2.294-.264c-.459-.034-.459-.666-.034-.666zM171.853 83.59l2.294.288c.413 0 .413.712 0 .655l-2.294-.276c-.413-.058-.424-.724 0-.666zM165.636 82.947l1.927.219c.413 0 .424.712 0 .666l-1.927-.23c-.413-.046-.425-.7 0-.655zM162.332 81.442l.711.655c.309.287-.149.758-.471.471l-.711-.666c-.344-.288.115-.747.471-.46zM161.505 77.593c0-.413.712-.425.666 0-.08.763-.118 1.53-.115 2.298a.33.33 0 01-.327.272.331.331 0 01-.327-.272c-.013-.767.022-1.535.103-2.298zM162.928 74.123l.666-.988c.229-.357.803 0 .562.333l-.654.988c-.241.356-.803.023-.574-.333zM179.229 67.079c.771.038 1.538.134 2.294.287.413.092.241.724-.172.644a11.92 11.92 0 00-2.111-.265c-.436-.034-.436-.666-.011-.666zM174.216 66.182c.731.035 1.459.115 2.18.242.424.069.241.7-.172.632a14.664 14.664 0 00-2.008-.207c-.413-.023-.413-.678 0-.667zM169.892 65.93a8.449 8.449 0 011.525-.116.332.332 0 010 .656 7.396 7.396 0 00-1.342.103c-.424.058-.596-.575-.183-.643zM166.92 69.159l.769-1.15c.24-.344.814 0 .562.334l-.769 1.15c-.264.344-.837.022-.562-.334zM165.016 72.493l.665-.885c.252-.333.826 0 .574.334l-.666.884c-.252.356-.826.035-.573-.333z'
                    fill='#2D3039'
                />
                <Path
                    d='M192.238 58.358c2.512.69 2.914.173 2.592 3.62-.321 3.447 0 3.113-3.246 2.505-2.294-.449-1.824-1.15-1.434-3.31.39-2.16.688-3.194 2.088-2.815zM164.752 54.715c2.581.357 2.914-.218 3.052 3.24.137 3.46-.562 3.207-2.891 2.908-2.329-.299-1.95-.85-1.858-3.08.091-2.229.263-3.263 1.697-3.068z'
                    fill='#FFBC1F'
                />
                <Path
                    d='M185.962 32.608s-2.776 1.655-1.525 6.584c-3.373-5.033 1.055-11.938 1.055-11.938a1.156 1.156 0 00.941.49 1.147 1.147 0 00.94-.49c3.35-3.448.952-4.597 0-4.195-1.194.4-2.429.662-3.682.782-1.95.322-3.854-2.838-3.854-2.838l.493 1.436a5.545 5.545 0 01-2.81-4.596c1.778-5.688 12.733-6.699 16.816 1.884 4.084 8.584 0 23.395 11.931 21.671-23.7 10.514-20.305-8.79-20.305-8.79z'
                    fill='#4A2407'
                />
                <Path
                    d='M139.275 104.721c6.779 9.595 18.847 21.223 18.847 21.223M177.359 130.103c11.827.449 28.449-4.596 28.449-4.596'
                    stroke='#1E325C'
                    strokeWidth={0.58}
                    strokeMiterlimit={10}
                />
                <Path
                    d='M66.08 57.903h53.515a7.478 7.478 0 015.288 2.165 7.459 7.459 0 012.205 5.262v33.94a7.439 7.439 0 01-2.205 5.262 7.473 7.473 0 01-5.288 2.165h-7.898v12.705L99.85 106.697H66.1a7.477 7.477 0 01-5.289-2.165 7.443 7.443 0 01-2.205-5.262V65.33a7.445 7.445 0 012.199-5.255 7.476 7.476 0 015.276-2.172z'
                    fill='#1C58D9'
                />
                <Path
                    d='M99.85 106.697H66.1a7.477 7.477 0 01-5.288-2.165 7.441 7.441 0 01-2.205-5.262V78.665s2.356 19.054 2.78 20.731c.423 1.677 1.263 4.187 5.244 4.603 3.98.416 33.22 2.698 33.22 2.698z'
                    fill='#000'
                    fillOpacity={0.16}
                />
                <Path
                    d='M111.116 77.448a4.817 4.817 0 00-4.454 2.97 4.8 4.8 0 001.045 5.243 4.823 4.823 0 005.254 1.043 4.824 4.824 0 002.163-1.772 4.802 4.802 0 00-.598-6.077 4.806 4.806 0 00-3.41-1.407zM92.837 77.448a4.828 4.828 0 00-4.454 2.97 4.801 4.801 0 001.045 5.243 4.823 4.823 0 005.253 1.043 4.804 4.804 0 001.566-7.848 4.816 4.816 0 00-3.41-1.408zM74.578 77.448a4.814 4.814 0 00-4.458 2.965 4.802 4.802 0 001.04 5.245 4.824 4.824 0 008.233-3.399 4.796 4.796 0 00-1.408-3.401 4.815 4.815 0 00-3.407-1.41z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M121.534 72.114a15.117 15.117 0 00-2.704-5.28 15.159 15.159 0 00-4.53-3.837.523.523 0 01.215-.99c3.374-.201 10.185.517 8.049 10.057a.525.525 0 01-.495.429.531.531 0 01-.535-.379z'
                    fill='#fff'
                    fillOpacity={0.16}
                />
                <Path
                    d='M70.946 13.983H8.512a8.763 8.763 0 00-3.337.648 8.716 8.716 0 00-2.833 1.867 8.652 8.652 0 00-1.898 2.801 8.607 8.607 0 00-.674 3.31v39.42a8.607 8.607 0 00.674 3.31 8.653 8.653 0 001.898 2.802 8.717 8.717 0 002.833 1.867 8.765 8.765 0 003.337.648h9.214v14.756l13.82-14.756h39.378a8.764 8.764 0 003.336-.648 8.717 8.717 0 002.833-1.867 8.653 8.653 0 001.898-2.802 8.608 8.608 0 00.675-3.31V22.61a8.627 8.627 0 00-2.565-6.104 8.742 8.742 0 00-6.155-2.522z'
                    fill='#FFBC1F'
                />
                <Path
                    d='M31.547 70.656h39.377a8.763 8.763 0 003.336-.648 8.718 8.718 0 002.833-1.867 8.651 8.651 0 001.898-2.802 8.606 8.606 0 00.675-3.31V38.098s-2.75 22.13-3.243 24.078c-.494 1.948-1.475 4.862-6.118 5.345-4.644.484-38.758 3.135-38.758 3.135z'
                    fill='#CC8F00'
                />
                <Path
                    d='M18.404 36.684c1.112 0 2.2.328 3.124.942a5.595 5.595 0 012.072 2.508 5.554 5.554 0 01-1.22 6.089 5.659 5.659 0 01-6.13 1.211 5.617 5.617 0 01-2.523-2.058 5.562 5.562 0 01.697-7.057 5.62 5.62 0 013.98-1.635zM39.73 36.684c1.112 0 2.2.328 3.124.942a5.596 5.596 0 012.072 2.508 5.553 5.553 0 01.32 3.228 5.576 5.576 0 01-1.54 2.86 5.658 5.658 0 01-6.13 1.211 5.617 5.617 0 01-2.523-2.057 5.561 5.561 0 01.698-7.057 5.62 5.62 0 013.979-1.635zM61.03 36.684a5.651 5.651 0 013.128.938 5.596 5.596 0 012.074 2.507 5.554 5.554 0 01-1.214 6.091 5.658 5.658 0 01-6.13 1.215 5.617 5.617 0 01-2.526-2.058 5.561 5.561 0 01.695-7.056 5.62 5.62 0 013.974-1.637z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M6.249 30.49a17.533 17.533 0 013.155-6.133A17.662 17.662 0 0114.69 19.9a.61.61 0 00.322-.67.607.607 0 00-.573-.48c-3.936-.234-11.882.601-9.39 11.68a.614.614 0 00.577.498.623.623 0 00.624-.439z'
                    fill='#FFD470'
                />
                <Ellipse
                    cx={185.757}
                    cy={209.889}
                    rx={44.4842}
                    ry={2.25131}
                    fill='#000'
                    fillOpacity={0.12}
                />
            </G>
        </Svg>
    );
};

export default ChatSvg;
