// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import * as React from 'react';
import Svg, {type SvgProps, G, Path, Defs, ClipPath} from 'react-native-svg';

const SearchHint = (props: SvgProps) => (
    <Svg
        width={72}
        height={48}
        fill='none'
        {...props}
    >
        <G clipPath='url(#a)'>
            <Path
                fill='#FFBC1F'
                d='M35.135 12.575H4.875a4.23 4.23 0 0 0-2.99 1.224 4.213 4.213 0 0 0-1.247 2.975v19.191a4.207 4.207 0 0 0 2.62 3.885c.513.21 1.063.317 1.617.315h4.466v7.184l6.699-7.184h19.085a4.23 4.23 0 0 0 3.91-2.588c.214-.51.325-1.058.327-1.612v-19.19a4.21 4.21 0 0 0-1.244-2.973 4.227 4.227 0 0 0-2.983-1.227Z'
            />
            <Path
                fill='#CC8F00'
                d='M16.04 40.165h19.085a4.231 4.231 0 0 0 2.99-1.224 4.216 4.216 0 0 0 1.247-2.976v-11.65s-1.333 10.773-1.572 11.722c-.24.948-.715 2.367-2.965 2.602-2.251.236-18.785 1.526-18.785 1.526Z'
            />
            <Path
                fill='#fff'
                d='M9.67 23.626a2.73 2.73 0 0 1 2.518 1.68 2.715 2.715 0 0 1-.59 2.964 2.727 2.727 0 0 1-4.654-1.923 2.712 2.712 0 0 1 1.682-2.515c.331-.136.686-.206 1.044-.206ZM20.006 23.626a2.73 2.73 0 0 1 2.518 1.68 2.715 2.715 0 0 1-.59 2.964 2.728 2.728 0 0 1-4.654-1.923 2.712 2.712 0 0 1 1.682-2.515c.33-.136.686-.206 1.044-.206ZM30.33 23.626a2.73 2.73 0 0 1 2.521 1.677 2.715 2.715 0 0 1-.589 2.966 2.727 2.727 0 0 1-4.448-2.963 2.718 2.718 0 0 1 2.516-1.68Z'
            />
            <Path
                fill='#FFD470'
                d='M3.779 20.61a8.549 8.549 0 0 1 4.09-5.155.297.297 0 0 0-.121-.56c-1.908-.114-5.76.293-4.552 5.687a.3.3 0 0 0 .469.187.299.299 0 0 0 .114-.159Z'
            />
            <Path
                fill='#fff'
                d='M32.333 7.29c2.446-2.476 5.531-3.752 9.252-3.82 3.652.068 6.72 1.337 9.202 3.82 2.476 2.482 3.751 5.55 3.82 9.202-.069 3.72-1.338 6.8-3.82 9.251-2.483 2.445-5.55 3.74-9.202 3.864-3.72-.13-6.8-1.419-9.252-3.864-2.445-2.451-3.733-5.537-3.863-9.258.13-3.652 1.418-6.719 3.863-9.195Z'
                opacity={0.4}
            />
            <Path
                fill='#000'
                fillOpacity={0.4}
                d='M53.57 14.168c-1.106-3.596-3.2-6.287-6.287-8.07-3.087-1.781-6.465-2.25-10.132-1.41-2.006.512-3.753 1.397-5.256 2.655 1.681-1.835 3.813-3.105 6.391-3.814 3.667-.84 7.063-.362 10.177 1.436s5.225 4.5 6.332 8.095c.68 2.59.646 5.072-.108 7.442-.748 2.373-2.091 4.366-4.032 5.971 1.457-1.588 2.46-3.452 3.005-5.602.54-2.154.51-4.383-.09-6.703Z'
            />
            <Path
                fill='#BABEC9'
                d='M57.62 15.478c-.262-3.86-1.828-7.25-4.694-10.17-3.263-3.11-7.03-4.67-11.3-4.67-4.27 0-8.031 1.56-11.295 4.67-3.126 3.248-4.693 6.99-4.693 11.24s1.567 7.998 4.693 11.239c2.996 2.858 6.421 4.398 10.27 4.62 3.847.23 7.396-.828 10.66-3.16l2.442 2.43 3.127-3.11-2.443-2.431c2.412-3.242 3.487-6.799 3.232-10.658Zm-6.751 10.218c-2.48 2.431-5.545 3.718-9.194 3.842-3.717-.13-6.794-1.41-9.243-3.842-2.443-2.43-3.73-5.499-3.86-9.198.13-3.63 1.418-6.68 3.86-9.148 2.443-2.462 5.526-3.73 9.243-3.798 3.65.068 6.714 1.33 9.194 3.798 2.474 2.468 3.748 5.517 3.816 9.148-.068 3.7-1.336 6.767-3.816 9.198Z'
            />
            <Path
                fill='#FFBC1F'
                d='M67.618 46.468c-.806.23-1.403.15-1.79-.243L53.145 32.306c-.387-.392-.547-.896-.486-1.52.062-.622.45-1.32 1.163-2.104.775-.716 1.465-1.127 2.08-1.227.615-.1 1.114.081 1.502.542l13.845 12.835c.387.392.449.978.19 1.762-.258.785-.744 1.57-1.452 2.354-.769.785-1.563 1.29-2.369 1.52Z'
            />
            <Path
                fill='#7A5600'
                d='m68.546 38.32-5.184 5.226-6.25-6.86 4.584-4.683 6.85 6.316Z'
            />
        </G>
        <Defs>
            <ClipPath id='a'>
                <Path
                    fill='#fff'
                    d='M0 0h72v48H0z'
                />
            </ClipPath>
        </Defs>
    </Svg>
);
export default SearchHint;
