// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import {defineMessages} from 'react-intl';

export const iosPermissions = defineMessages({
    NSAppleMusicUsageDescription: {
        id: 'mobile.ios.plist.NSAppleMusicUsageDescription',
        defaultMessage: 'Enabling access to your media library means you can attach files from your media library to your messages in {applicationName}.',
    },
    NSBluetoothAlwaysUsageDescription: {
        id: 'mobile.ios.plist.NSBluetoothAlwaysUsageDescription',
        defaultMessage: 'Enabling access to Bluetooth means we can synchronize content across your devices and clients.',
    },
    NSBluetoothPeripheralUsageDescription: {
        id: 'mobile.ios.plist.NSBluetoothPeripheralUsageDescription',
        defaultMessage: 'Enabling access to Bluetooth means we can connect to audio peripherals for calls, and synchronize content across your devices and clients.',
    },
    NSCameraUsageDescription: {
        id: 'mobile.ios.plist.NSCameraUsageDescription',
        defaultMessage: 'Allowing access to your camera enables you to take photos or videos and attach them to messages.',
    },
    NSFaceIDUsageDescription: {
        id: 'mobile.ios.plist.NSFaceIDUsageDescription',
        defaultMessage: 'Enabling access to your Face ID means we can restrict unauthorized users from accessing {applicationName} on your device.',
    },
    NSLocationAlwaysUsageDescription: {
        id: 'mobile.ios.plist.NSLocationAlwaysUsageDescription',
        defaultMessage: 'Enabling access to your location data means we can add location metadata to pictures and videos you share in {applicationName}.',
    },
    NSLocationWhenInUseUsageDescription: {
        id: 'mobile.ios.plist.NSLocationWhenInUseUsageDescription',
        defaultMessage: 'Enabling access to your location data means we can add location metadata to pictures and videos you share in {applicationName}.',
    },
    NSMicrophoneUsageDescription: {
        id: 'mobile.ios.plist.NSMicrophoneUsageDescription',
        defaultMessage: 'Enabling access to your device\'s microphones means you can capture audio for calls or videos to share in {applicationName}.',
    },
    NSPhotoLibraryAddUsageDescription: {
        id: 'mobile.ios.plist.NSPhotoLibraryAddUsageDescription',
        defaultMessage: 'Enabling write access to your photo library means you can save downloaded photos and videos from {applicationName} to your device.',
    },
    NSPhotoLibraryUsageDescription: {
        id: 'mobile.ios.plist.NSPhotoLibraryUsageDescription',
        defaultMessage: 'Allowing access to your photo library enables you to select photos or videos and attach them to messages.',
    },
    NSSpeechRecognitionUsageDescription: {
        id: 'mobile.ios.plist.NSSpeechRecognitionUsageDescription',
        defaultMessage: 'Enabling your device to send user data to Apple means you can send voice messages to {applicationName}.',
    },
});

export default {
    PERMISSIONS_ALL: 'all',
    PERMISSIONS_CHANNEL_ADMIN: 'channel_admin',
    PERMISSIONS_TEAM_ADMIN: 'team_admin',
    PERMISSIONS_SYSTEM_ADMIN: 'system_admin',
    TEAM_GUEST_ROLE: 'team_guest',
    TEAM_USER_ROLE: 'team_user',
    TEAM_ADMIN_ROLE: 'team_admin',
    CHANNEL_GUEST_ROLE: 'channel_guest',
    CHANNEL_USER_ROLE: 'channel_user',
    CHANNEL_ADMIN_ROLE: 'channel_admin',
    SYSTEM_GUEST_ROLE: 'system_guest',
    SYSTEM_USER_ROLE: 'system_user',
    SYSTEM_ADMIN_ROLE: 'system_admin',
    SYSTEM_USER_ACCESS_TOKEN_ROLE: 'system_user_access_token',
    SYSTEM_POST_ALL_ROLE: 'system_post_all',
    SYSTEM_POST_ALL_PUBLIC_ROLE: 'system_post_all_public',
    ALLOW_EDIT_POST_ALWAYS: 'always',
    ALLOW_EDIT_POST_NEVER: 'never',
    ALLOW_EDIT_POST_TIME_LIMIT: 'time_limit',
    DEFAULT_POST_EDIT_TIME_LIMIT: 300,
    RESTRICT_DIRECT_MESSAGE_ANY: 'any',
    RESTRICT_DIRECT_MESSAGE_TEAM: 'team',
    INVITE_USER: 'invite_user',
    ADD_USER_TO_TEAM: 'add_user_to_team',
    USE_SLASH_COMMANDS: 'use_slash_commands',
    MANAGE_SLASH_COMMANDS: 'manage_slash_commands',
    MANAGE_OTHERS_SLASH_COMMANDS: 'manage_others_slash_commands',
    CREATE_PUBLIC_CHANNEL: 'create_public_channel',
    CREATE_PRIVATE_CHANNEL: 'create_private_channel',
    MANAGE_PUBLIC_CHANNEL_MEMBERS: 'manage_public_channel_members',
    MANAGE_PRIVATE_CHANNEL_MEMBERS: 'manage_private_channel_members',
    ASSIGN_SYSTEM_ADMIN_ROLE: 'assign_system_admin_role',
    MANAGE_ROLES: 'manage_roles',
    MANAGE_TEAM_ROLES: 'manage_team_roles',
    MANAGE_CHANNEL_ROLES: 'manage_channel_roles',
    MANAGE_SYSTEM: 'manage_system',
    CREATE_DIRECT_CHANNEL: 'create_direct_channel',
    CREATE_GROUP_CHANNEL: 'create_group_channel',
    MANAGE_PUBLIC_CHANNEL_PROPERTIES: 'manage_public_channel_properties',
    MANAGE_PRIVATE_CHANNEL_PROPERTIES: 'manage_private_channel_properties',
    LIST_PUBLIC_TEAMS: 'list_public_teams',
    JOIN_PUBLIC_TEAMS: 'join_public_teams',
    LIST_PRIVATE_TEAMS: 'list_private_teams',
    JOIN_PRIVATE_TEAMS: 'join_private_teams',
    LIST_TEAM_CHANNELS: 'list_team_channels',
    JOIN_PUBLIC_CHANNELS: 'join_public_channels',
    DELETE_PUBLIC_CHANNEL: 'delete_public_channel',
    CONVERT_PUBLIC_CHANNEL_TO_PRIVATE: 'convert_public_channel_to_private',
    DELETE_PRIVATE_CHANNEL: 'delete_private_channel',
    EDIT_OTHER_USERS: 'edit_other_users',
    READ_CHANNEL: 'read_channel',
    READ_PUBLIC_CHANNEL: 'read_public_channel',
    ADD_REACTION: 'add_reaction',
    REMOVE_REACTION: 'remove_reaction',
    REMOVE_OTHERS_REACTIONS: 'remove_others_reactions',
    PERMANENT_DELETE_USER: 'permanent_delete_user',
    UPLOAD_FILE: 'upload_file',
    GET_PUBLIC_LINK: 'get_public_link',
    MANAGE_WEBHOOKS: 'manage_webhooks',
    MANAGE_OTHERS_WEBHOOKS: 'manage_others_webhooks',
    MANAGE_INCOMING_WEBHOOKS: 'manage_incoming_webhooks',
    MANAGE_OTHERS_INCOMING_WEBHOOKS: 'manage_others_incoming_webhooks',
    MANAGE_OUTGOING_WEBHOOKS: 'manage_outgoing_webhooks',
    MANAGE_OTHERS_OUTGOING_WEBHOOKS: 'manage_others_outgoing_webhooks',
    MANAGE_OAUTH: 'manage_oauth',
    MANAGE_SYSTEM_WIDE_OAUTH: 'manage_system_wide_oauth',
    CREATE_POST: 'create_post',
    CREATE_POST_PUBLIC: 'create_post_public',
    EDIT_POST: 'edit_post',
    EDIT_OTHERS_POSTS: 'edit_others_posts',
    DELETE_POST: 'delete_post',
    DELETE_OTHERS_POSTS: 'delete_others_posts',
    REMOVE_USER_FROM_TEAM: 'remove_user_from_team',
    CREATE_TEAM: 'create_team',
    MANAGE_TEAM: 'manage_team',
    IMPORT_TEAM: 'import_team',
    VIEW_TEAM: 'view_team',
    LIST_USERS_WITHOUT_TEAM: 'list_users_without_team',
    CREATE_USER_ACCESS_TOKEN: 'create_user_access_token',
    READ_USER_ACCESS_TOKEN: 'read_user_access_token',
    REVOKE_USER_ACCESS_TOKEN: 'revoke_user_access_token',
    MANAGE_JOBS: 'manage_jobs',
    MANAGE_EMOJIS: 'manage_emojis',
    MANAGE_OTHERS_EMOJIS: 'manage_others_emojis',
    CREATE_EMOJIS: 'create_emojis',
    DELETE_EMOJIS: 'delete_emojis',
    DELETE_OTHERS_EMOJIS: 'delete_others_emojis',
    VIEW_MEMBERS: 'view_members',
    INVITE_GUEST: 'invite_guest',
    PROMOTE_GUEST: 'promote_guest',
    DEMOTE_TO_GUEST: 'demote_to_guest',
    USE_CHANNEL_MENTIONS: 'use_channel_mentions',
    USE_GROUP_MENTIONS: 'use_group_mentions',

    CHANNEL_MODERATED_PERMISSIONS: {
        CREATE_POST: 'create_post',
        CREATE_REACTIONS: 'create_reactions',
        MANAGE_MEMBERS: 'manage_members',
        USE_CHANNEL_MENTIONS: 'use_channel_mentions',
    },
    MANAGE_BOTS: 'manage_bots',
    MANAGE_OTHERS_BOTS: 'manage_others_bots',
    ADD_BOOKMARK_PUBLIC_CHANNEL: 'add_bookmark_public_channel',
    ADD_BOOKMARK_PRIVATE_CHANNEL: 'add_bookmark_private_channel',
    EDIT_BOOKMARK_PUBLIC_CHANNEL: 'edit_bookmark_public_channel',
    EDIT_BOOKMARK_PRIVATE_CHANNEL: 'edit_bookmark_private_channel',
    DELETE_BOOKMARK_PUBLIC_CHANNEL: 'delete_bookmark_public_channel',
    DELETE_BOOKMARK_PRIVATE_CHANNEL: 'delete_bookmark_private_channel',
};
