// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.
import * as React from 'react';
import Svg, {
    type SvgProps,
    Circle,
    G,
    Path,
    Defs,
    ClipPath,
} from 'react-native-svg';

const LongPressIllustration = (props: SvgProps) => (
    <Svg
        width={69}
        height={79}
        fill='none'
        {...props}
    >
        <Circle
            cx={31}
            cy={22.5}
            r={8.5}
            fill='#3F4350'
            fillOpacity={0.24}
        />
        <Circle
            cx={31}
            cy={22}
            r={21}
            stroke='#3F4350'
            strokeOpacity={0.08}
            strokeWidth={2}
        />
        <Circle
            cx={31}
            cy={22}
            r={14}
            stroke='#3F4350'
            strokeOpacity={0.16}
            strokeWidth={2}
        />
        <G clipPath='url(#a)'>
            <Path
                fill='#FFBC1F'
                fillRule='evenodd'
                d='M23.882 59.329c-.1-.21-.197-.425-.292-.649-.428-.95-.842-1.942-1.235-2.882-.754-1.805-1.43-3.424-1.977-4.222l-.017-.02a35.985 35.985 0 0 0-3.308-3.592l-.107-.348c-.11-.118-.237-.252-.378-.399-1.246-1.304-3.473-3.633-2.704-5.036.811-1.48 3.02-2.092 4.123-1.857 1.103.235 2.797 1.53 2.797 1.53l3.496 3.063 1.944 2.786v.001c.6-.675.929-1.078.929-1.078s.51-11.737.48-14.437c-.031-2.7-.041-11.161.132-11.855.174-.694.74-2.271 3.313-1.878 2.572.393 3.01 2.398 3.01 2.398l.26 4.083.44 13.34s.398-4.016 1.5-4.807c.78-.562 2.771-.454 3.884 0 1.342.566 1.868 4.797 1.868 4.797s.382-2.174.872-3.006c.705-1.189 3.113-.342 3.966.296.633.48 1.235 5.445 1.235 5.445s-.062-1.53.678-2.184c.603-.51 2.43-.168 2.94.373 1.169 1.245 1.674 4.715 1.674 4.715l.26 2.16v4.45c.205 2.507.064 5.626-.686 7.457-.24.585-.46 1.064-.663 1.508-.434.946-.794 1.732-1.116 3.04-.026.41-.24 3.633-.607 4.555-.393.985-1.7 2.419-3.792 3.205a21.945 21.945 0 0 1-9.227 1.439c-1.875-.127-6.538-1.059-7.053-3.39-.206-.936-.758-1.797-1.33-2.548-1.483-1.431-4.284-4.296-5.29-6.424l-.02-.03Z'
                clipRule='evenodd'
            />
            <Path
                fill='#CC8F00'
                d='M36.885 33.21s-1.36.348-.597 10.396c.234 2.465-1.352 4.47-1.25 2.633.173-3.062-.393-6.502-.179-8.676.46-4.532 2.026-4.353 2.026-4.353ZM44.132 34.68s-2.005-.255-.829 9.855c.245 2.465.447 3.29-.273 2.24-1.108-1.623-1.123-3.603-1.077-7.951.046-4.532 2.18-4.145 2.18-4.145ZM49.701 38.578s-1.36 1.167-.435 7.071c.542 3.322.975 3.009.822 3.152-.153.142-1.659-.837-2.01-6.257-.26-2.108.292-3.274.622-3.636.33-.362 1.001-.33 1.001-.33ZM30.127 18.42s-1.58.23-1.473 4.583c.163 6.7.51 7.354.372 11.375-.137 4.022.638 9.554-1.076 12.81-1.093 2.077-1.838.51-1.838.51s2.307-1.913 1.332-24.685c-.283-4.927 2.683-4.593 2.683-4.593Z'
            />
            <Path
                fill='#FFD470'
                d='M28.984 23.479c-.362-.904-.814-4.16-.362-4.521.452-.362 4.022-.187 4.34.296.272.411.181 3.23 0 4.225-.18.995-3.568 1.025-3.978 0Z'
            />
            <Path
                fill='#CC8F00'
                d='M16.61 46.52s2.628 2.47 4.7 4.342c1.31 1.185 3.512 6.112 3.502 6.049.21.723 1.862 4.426 3.852 5.567 4.3 2.465 2.863 7.88 9.517 7.803 5.231-.061 11.526-1.168 13.021-7.803 0 0-.216 3.613-.609 4.598-.393.985-1.7 2.419-3.792 3.205a21.945 21.945 0 0 1-9.227 1.439c-1.875-.127-6.538-1.059-7.053-3.39-.206-.936-.758-1.797-1.33-2.548-1.49-1.438-4.309-4.322-5.304-6.453-1.378-2.95-2.639-6.517-3.537-7.793a35.982 35.982 0 0 0-3.297-3.572l-.444-1.445Z'
            />
            <Path
                fill='#F5AB00'
                d='M29.599 21.771c-.145-1.085 0-3.012 0-3.012-.181 0-.877.064-1 .213-.194.231-.193.82-.146 1.628.066 1.113.341 2.45.531 2.879.264.596 1.471.754 1.953.754-.452-.181-1.157-1.105-1.338-2.462Z'
            />
            <Path
                fill='#FFD470'
                d='M17.048 47.969a6.16 6.16 0 0 0-3.062-5.997c-.408-.25-1.059.761-.706 1.205.352.444 3.13 4.006 3.768 4.792Z'
            />
            <Path
                fill='#F5AB00'
                d='m13.281 42.44 3.796 4.516s.036.26.022.562c-.015.301-.05.45-.05.45s-2.19-2.633-3.22-4.082c-.572-.76-.808-.796-.548-1.447Z'
            />
        </G>
        <Defs>
            <ClipPath id='a'>
                <Path
                    fill='#fff'
                    d='M13.16 18.415h40.914v53.35H13.16z'
                />
            </ClipPath>
        </Defs>
    </Svg>
);
export default LongPressIllustration;
