/**
 * Turn a selector into a tree.
 *
 * @param {string} [selector='']
 *   CSS selector.
 * @param {Space | Options} [space='html']
 *   Space or configuration.
 * @returns {HastElement}
 *   Built tree.
 */
export function fromSelector(
  selector?: string | undefined,
  space?: Space | Options | undefined
): HastElement
export type RuleAttr = import('css-selector-parser').RuleAttr
export type RulePseudo = import('css-selector-parser').RulePseudo
export type Rule = import('css-selector-parser').Rule
export type HastElement = import('hast').Element
export type HastProperties = import('hast').Properties
export type Space = 'html' | 'svg'
/**
 * Configuration.
 */
export type Options = {
  /**
   * Which space first element in the selector is in.
   *
   * When an `svg` element is created in HTML, the space is automatically
   * switched to SVG.
   */
  space?: Space | undefined
}
/**
 * Info on current context.
 */
export type State = {
  /**
   * Current space.
   */
  space: Space
}
