/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAnonymousAliasCppName = exports.getAliasCppName = exports.setPreferredModuleName = void 0;
let preferredModuleName = '';
function setPreferredModuleName(moduleName) {
    preferredModuleName = moduleName;
}
exports.setPreferredModuleName = setPreferredModuleName;
function getAliasCppName(typeName) {
    return `${preferredModuleName}Spec_${typeName}`;
}
exports.getAliasCppName = getAliasCppName;
const ExtendedObjectKey = '$RNW-TURBOMODULE-ALIAS';
function recordAnonymousAlias(aliases, baseAliasName, extended) {
    extended[ExtendedObjectKey] = baseAliasName;
    aliases.types[baseAliasName] = extended;
    aliases.jobs.push(baseAliasName);
    return baseAliasName;
}
function getAnonymousAliasCppName(aliases, baseAliasName, objectType) {
    // someone found an anonymous object literal type
    // if the ExtendedObjectKey flag has been set
    // then it is a known one
    // this happens because method signatures are generate twice in spec and error messages
    const extended = objectType;
    const key = extended[ExtendedObjectKey];
    if (key !== undefined) {
        return getAliasCppName(key);
    }
    // if the ExtendedObjectKey flag has not been set
    // it means it is a unknown one
    // associate the name with this object literal type and return
    if (aliases.types[baseAliasName] === undefined) {
        return getAliasCppName(recordAnonymousAlias(aliases, baseAliasName, extended));
    }
    // sometimes names could be anonymous
    let index = 2;
    while (aliases.types[`${baseAliasName}${index}`] !== undefined) {
        index++;
    }
    return getAliasCppName(recordAnonymousAlias(aliases, `${baseAliasName}${index}`, extended));
}
exports.getAnonymousAliasCppName = getAnonymousAliasCppName;
//# sourceMappingURL=AliasManaging.js.map