"use strict";

import { NativeEventEmitter, Platform } from 'react-native';
import RNEmm from './emm-native';
const emitter = new NativeEventEmitter(RNEmm);
const Emm = {
  addListener: callback => {
    return emitter.addListener('managedConfigChanged', config => {
      callback(config);
    });
  },
  authenticate: async opts => {
    try {
      const options = {
        reason: opts.reason || '',
        description: opts.description || '',
        fallback: opts.fallback || true,
        supressEnterPassword: opts.supressEnterPassword || false,
        blurOnAuthenticate: opts.blurOnAuthenticate || false
      };
      await RNEmm.authenticate(options);
      return true;
    } catch {
      return false;
    }
  },
  getManagedConfig: () => RNEmm.getManagedConfig(),
  isDeviceSecured: async () => {
    try {
      const result = await RNEmm.deviceSecureWith();
      return result.face || result.fingerprint || result.passcode;
    } catch {
      return false;
    }
  },
  openSecuritySettings: () => {
    if (Platform.OS === 'android') {
      RNEmm.openSecuritySettings();
    }
  },
  setAppGroupId: identifier => {
    if (Platform.OS === 'ios') {
      RNEmm.setAppGroupId(identifier);
    }
  },
  deviceSecureWith: function () {
    return RNEmm.deviceSecureWith();
  },
  enableBlurScreen: function (enabled) {
    return RNEmm.setBlurScreen(enabled);
  },
  applyBlurEffect: (radius = 8) => RNEmm.applyBlurEffect(radius),
  removeBlurEffect: () => RNEmm.removeBlurEffect(),
  exitApp: function () {
    RNEmm.exitApp();
  }
};
export default Emm;
//# sourceMappingURL=emm.js.map