"use strict";

import React, { createContext, useEffect, useState, useContext } from 'react';
import Emm from './emm';
import { jsx as _jsx } from "react/jsx-runtime";
const initialContext = Emm.getManagedConfig();
const Context = /*#__PURE__*/createContext(initialContext);
export function useManagedConfig() {
  return useContext(Context);
}
export const Provider = ({
  children
}) => {
  const [managed, setManaged] = useState(Emm.getManagedConfig());
  useEffect(() => {
    const listener = Emm.addListener(config => {
      setManaged(config);
    });
    return () => {
      listener.remove();
    };
  });
  return /*#__PURE__*/_jsx(Context.Provider, {
    value: managed,
    children: children
  });
};
export function withManagedConfig(Component) {
  return function ManagedConfigComponent(props) {
    return /*#__PURE__*/_jsx(Context.Consumer, {
      children: managedConfig => /*#__PURE__*/_jsx(Component, {
        ...props,
        managedConfig: managedConfig
      })
    });
  };
}
export default Context;
//# sourceMappingURL=context.js.map