/* @generated */
// prettier-ignore
if (Intl.NumberFormat && typeof Intl.NumberFormat.__addLocaleData === 'function') {
  Intl.NumberFormat.__addLocaleData({
  "data": {
    "currencies": {
      "AED": {
        "displayName": {
          "other": "UAE ᎠᏕᎳ"
        },
        "narrow": "AED",
        "symbol": "AED"
      },
      "AFN": {
        "displayName": {
          "other": "ᎠᏫᎨᏂᏍᏖᏂ ᎠᏕᎳ"
        },
        "narrow": "؋",
        "symbol": "AFN"
      },
      "ALL": {
        "displayName": {
          "other": "ᎠᎵᏇᏂᏯ ᎠᏕᎳ"
        },
        "narrow": "ALL",
        "symbol": "ALL"
      },
      "AMD": {
        "displayName": {
          "other": "ᎠᎵᎻᏂᎠ ᎠᏕᎳ"
        },
        "narrow": "֏",
        "symbol": "AMD"
      },
      "ANG": {
        "displayName": {
          "other": "ᎾᏍᎩᏁᏛᎳᏂ ᎠᏂᏘᎵᏏ ᎠᏕᎳ"
        },
        "narrow": "ANG",
        "symbol": "ANG"
      },
      "AOA": {
        "displayName": {
          "other": "ᎠᏂᎪᎳ ᎠᏕᎳ"
        },
        "narrow": "Kz",
        "symbol": "AOA"
      },
      "ARS": {
        "displayName": {
          "other": "ᎠᏥᏂᏘᏂᎠ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "ARS"
      },
      "AUD": {
        "displayName": {
          "other": "ᎡᎳᏗᏜ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "A$"
      },
      "AWG": {
        "displayName": {
          "other": "ᎠᎷᏆ ᎠᏕᎳ"
        },
        "narrow": "AWG",
        "symbol": "AWG"
      },
      "AZN": {
        "displayName": {
          "other": "ᎠᏏᎵᏆᏌᏂ ᎠᏕᎳ"
        },
        "narrow": "₼",
        "symbol": "AZN"
      },
      "BAM": {
        "displayName": {
          "other": "ᏉᏏᏂᎠ-ᎲᏤᎪᏫ ᎦᏁᏟᏴᏍᏔᏅ ᎠᏕᎳ"
        },
        "narrow": "KM",
        "symbol": "BAM"
      },
      "BBD": {
        "displayName": {
          "other": "ᏆᏇᏙᏍ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "BBD"
      },
      "BDT": {
        "displayName": {
          "other": "ᏆᏂᎦᎵᏕᏍ ᎠᏕᎳ"
        },
        "narrow": "৳",
        "symbol": "BDT"
      },
      "BGN": {
        "displayName": {
          "other": "ᏊᎵᎨᎵᎠ ᎠᏕᎳ"
        },
        "narrow": "BGN",
        "symbol": "BGN"
      },
      "BHD": {
        "displayName": {
          "other": "ᏆᎭᎴᎢᏂ ᎠᏕᎳ"
        },
        "narrow": "BHD",
        "symbol": "BHD"
      },
      "BIF": {
        "displayName": {
          "other": "ᏋᎷᏂᏗ ᎠᏕᎳ"
        },
        "narrow": "BIF",
        "symbol": "BIF"
      },
      "BMD": {
        "displayName": {
          "other": "ᏆᏊᏓ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "BMD"
      },
      "BND": {
        "displayName": {
          "other": "ᏊᎾᎢ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "BND"
      },
      "BOB": {
        "displayName": {
          "other": "ᏉᎵᏫᎠ ᎠᏕᎳ"
        },
        "narrow": "Bs",
        "symbol": "BOB"
      },
      "BRL": {
        "displayName": {
          "other": "ᏆᏏᎵᎢ ᎠᏕᎳ"
        },
        "narrow": "R$",
        "symbol": "R$"
      },
      "BSD": {
        "displayName": {
          "other": "ᏆᎭᎹ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "BSD"
      },
      "BTN": {
        "displayName": {
          "other": "ᏊᏔᏂ ᎠᏕᎳ"
        },
        "narrow": "BTN",
        "symbol": "BTN"
      },
      "BWP": {
        "displayName": {
          "other": "ᏆᏣᏩᎾ ᎠᏕᎳ"
        },
        "narrow": "P",
        "symbol": "BWP"
      },
      "BYN": {
        "displayName": {
          "other": "ᏇᎳᎷᏍ ᎠᏕᎳ"
        },
        "narrow": "р.",
        "symbol": "BYN"
      },
      "BYR": {
        "displayName": {
          "other": "ᏇᎳᎷᏍ ᎠᏕᎳ (2000–2016)"
        },
        "narrow": "BYR",
        "symbol": "BYR"
      },
      "BZD": {
        "displayName": {
          "other": "ᏇᎵᏍ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "BZD"
      },
      "CAD": {
        "displayName": {
          "other": "ᎨᎾᏓ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "CA$"
      },
      "CDF": {
        "displayName": {
          "other": "ᎧᏂᎪ ᎠᏕᎳ"
        },
        "narrow": "CDF",
        "symbol": "CDF"
      },
      "CHF": {
        "displayName": {
          "other": "ᏍᏫᏏ ᎠᏕᎳ"
        },
        "narrow": "CHF",
        "symbol": "CHF"
      },
      "CLP": {
        "displayName": {
          "other": "ᏥᎵ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "CLP"
      },
      "CNH": {
        "displayName": {
          "other": "ᏣᏂᏏ ᎠᏕᎳ (ᏓᎹᏳᏟᏗ)"
        },
        "narrow": "CNH",
        "symbol": "CNH"
      },
      "CNY": {
        "displayName": {
          "other": "ᏓᎶᏂᎨ ᎠᏕᎳ"
        },
        "narrow": "¥",
        "symbol": "CN¥"
      },
      "COP": {
        "displayName": {
          "other": "ᎪᎸᎻᏈᎢᎠ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "COP"
      },
      "CRC": {
        "displayName": {
          "other": "ᎪᏍᏓᎵᎧ ᎠᏕᎳ"
        },
        "narrow": "₡",
        "symbol": "CRC"
      },
      "CUC": {
        "displayName": {
          "other": "ᎫᏆ ᎦᏁᏟᏴᏍᏔᏅ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "CUC"
      },
      "CUP": {
        "displayName": {
          "other": "ᎫᏆ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "CUP"
      },
      "CVE": {
        "displayName": {
          "other": "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ ᎠᏕᎳ"
        },
        "narrow": "CVE",
        "symbol": "CVE"
      },
      "CZK": {
        "displayName": {
          "other": "ᏤᎩ ᎠᏕᎳ"
        },
        "narrow": "Kč",
        "symbol": "CZK"
      },
      "DJF": {
        "displayName": {
          "other": "ᏥᏊᏗ ᎠᏕᎳ"
        },
        "narrow": "DJF",
        "symbol": "DJF"
      },
      "DKK": {
        "displayName": {
          "other": "ᏕᏂᏍ ᎠᏕᎳ"
        },
        "narrow": "kr",
        "symbol": "DKK"
      },
      "DOP": {
        "displayName": {
          "other": "ᏙᎻᏂᎧᏂ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "DOP"
      },
      "DZD": {
        "displayName": {
          "other": "ᎠᎵᏥᎵᏯ ᎠᏕᎳ"
        },
        "narrow": "DZD",
        "symbol": "DZD"
      },
      "EGP": {
        "displayName": {
          "other": "ᎢᏥᏈᎢ ᎠᏕᎳ"
        },
        "narrow": "E£",
        "symbol": "EGP"
      },
      "ERN": {
        "displayName": {
          "other": "ᎡᎵᏟᏯ ᎠᏕᎳ"
        },
        "narrow": "ERN",
        "symbol": "ERN"
      },
      "ESP": {
        "displayName": {
        },
        "narrow": "₧",
        "symbol": "ESP"
      },
      "ETB": {
        "displayName": {
          "other": "ᎢᏗᎣᏈᎠ ᎠᏕᎳ"
        },
        "narrow": "ETB",
        "symbol": "ETB"
      },
      "EUR": {
        "displayName": {
          "other": "ᏳᎳᏛ ᎠᏕᎳ"
        },
        "narrow": "€",
        "symbol": "€"
      },
      "FJD": {
        "displayName": {
          "other": "ᏫᎩ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "FJD"
      },
      "FKP": {
        "displayName": {
          "other": "ᏩᎩᎤ ᏚᎦᏚᏛᎢ ᎠᏕᎳ"
        },
        "narrow": "£",
        "symbol": "FKP"
      },
      "GBP": {
        "displayName": {
          "other": "ᎩᎵᏏᏲ ᎠᏕᎳ"
        },
        "narrow": "£",
        "symbol": "£"
      },
      "GEL": {
        "displayName": {
          "other": "ᏣᎠᏥᎢ ᎠᏕᎳ"
        },
        "narrow": "₾",
        "symbol": "GEL"
      },
      "GHS": {
        "displayName": {
          "other": "ᎦᎠᎾ ᎠᏕᎳ"
        },
        "narrow": "GH₵",
        "symbol": "GHS"
      },
      "GIP": {
        "displayName": {
          "other": "ᏥᏆᎵᏓ ᎠᏕᎳ"
        },
        "narrow": "£",
        "symbol": "GIP"
      },
      "GMD": {
        "displayName": {
          "other": "ᎦᎹᏈᎢᎠ ᎠᏕᎳ"
        },
        "narrow": "GMD",
        "symbol": "GMD"
      },
      "GNF": {
        "displayName": {
          "other": "ᎩᎢᏂ ᎠᏕᎳ"
        },
        "narrow": "FG",
        "symbol": "GNF"
      },
      "GTQ": {
        "displayName": {
          "other": "ᏆᏖᎹᎳ ᎠᏕᎳ"
        },
        "narrow": "Q",
        "symbol": "GTQ"
      },
      "GYD": {
        "displayName": {
          "other": "ᎦᏯᎾ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "GYD"
      },
      "HKD": {
        "displayName": {
          "other": "ᎰᏂᎩ ᎪᏂᎩ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "HK$"
      },
      "HNL": {
        "displayName": {
          "other": "ᎭᏂᏚᎳᏍ ᎠᏕᎳ"
        },
        "narrow": "L",
        "symbol": "HNL"
      },
      "HRK": {
        "displayName": {
          "other": "ᎧᎶᎡᏏᎠ ᎠᏕᎳ"
        },
        "narrow": "kn",
        "symbol": "HRK"
      },
      "HTG": {
        "displayName": {
          "other": "ᎮᏘ ᎠᏕᎳ"
        },
        "narrow": "HTG",
        "symbol": "HTG"
      },
      "HUF": {
        "displayName": {
          "other": "ᎲᏂᎦᎵ ᎠᏕᎳ"
        },
        "narrow": "Ft",
        "symbol": "HUF"
      },
      "IDR": {
        "displayName": {
          "other": "ᎢᏂᏙᏂᏍᏯ ᎠᏕᎳ"
        },
        "narrow": "Rp",
        "symbol": "IDR"
      },
      "ILS": {
        "displayName": {
          "other": "ᎢᏏᎵᏱ ᎢᏤ ᎠᏕᎳ"
        },
        "narrow": "₪",
        "symbol": "₪"
      },
      "INR": {
        "displayName": {
          "other": "ᎢᏂᏗᎢᎠ ᎠᏕᎳ"
        },
        "narrow": "₹",
        "symbol": "₹"
      },
      "IQD": {
        "displayName": {
          "other": "ᎢᎳᎩ ᎠᏕᎳ"
        },
        "narrow": "IQD",
        "symbol": "IQD"
      },
      "IRR": {
        "displayName": {
          "other": "ᎢᎴᏂ ᎠᏕᎳ"
        },
        "narrow": "IRR",
        "symbol": "IRR"
      },
      "ISK": {
        "displayName": {
          "other": "ᏧᏁᏍᏓᎸᎯ ᎠᏕᎳ"
        },
        "narrow": "kr",
        "symbol": "ISK"
      },
      "JMD": {
        "displayName": {
          "other": "ᏣᎺᎢᎧ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "JMD"
      },
      "JOD": {
        "displayName": {
          "other": "ᏦᏓᏂ ᎠᏕᎳ"
        },
        "narrow": "JOD",
        "symbol": "JOD"
      },
      "JPY": {
        "displayName": {
          "other": "ᏣᏩᏂᏏ ᎠᏕᎳ"
        },
        "narrow": "¥",
        "symbol": "JP¥"
      },
      "KES": {
        "displayName": {
          "other": "ᎨᏂᏯ ᎠᏕᎳ"
        },
        "narrow": "KES",
        "symbol": "KES"
      },
      "KGS": {
        "displayName": {
          "other": "ᎩᎵᏣᎢᏍ ᎠᏕᎳ"
        },
        "narrow": "⃀",
        "symbol": "KGS"
      },
      "KHR": {
        "displayName": {
          "other": "ᎧᎹᏉᏗᎠᏂ ᎠᏕᎳ"
        },
        "narrow": "៛",
        "symbol": "KHR"
      },
      "KMF": {
        "displayName": {
          "other": "ᎪᎼᎳᏍ ᎠᏕᎳ"
        },
        "narrow": "CF",
        "symbol": "KMF"
      },
      "KPW": {
        "displayName": {
          "other": "ᏧᏴᏢ ᎪᎵᎠ ᎠᏕᎳ"
        },
        "narrow": "₩",
        "symbol": "KPW"
      },
      "KRW": {
        "displayName": {
          "other": "ᏧᎦᎾᏮ ᎪᎵᎠ ᎠᏕᎳ"
        },
        "narrow": "₩",
        "symbol": "₩"
      },
      "KWD": {
        "displayName": {
          "other": "ᎫᏪᎢᏘ ᎠᏕᎳ"
        },
        "narrow": "KWD",
        "symbol": "KWD"
      },
      "KYD": {
        "displayName": {
          "other": "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "KYD"
      },
      "KZT": {
        "displayName": {
          "other": "ᎧᏎᎧᏍᏕᏂ ᎠᏕᎳ"
        },
        "narrow": "₸",
        "symbol": "KZT"
      },
      "LAK": {
        "displayName": {
          "other": "ᎳᎣ ᎠᏕᎳ"
        },
        "narrow": "₭",
        "symbol": "LAK"
      },
      "LBP": {
        "displayName": {
          "other": "ᎴᏆᎾᏂ ᎠᏕᎳ"
        },
        "narrow": "L£",
        "symbol": "LBP"
      },
      "LKR": {
        "displayName": {
          "other": "ᏍᎵ ᎳᏂᎧ ᎠᏕᎳ"
        },
        "narrow": "Rs",
        "symbol": "LKR"
      },
      "LRD": {
        "displayName": {
          "other": "ᎳᏈᎵᏯ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "LRD"
      },
      "LSL": {
        "displayName": {
          "one": "ᎴᏐᏠ ᎶᏘ",
          "other": "ᎴᏐᏠ ᎶᏘᏍ"
        },
        "narrow": "LSL",
        "symbol": "LSL"
      },
      "LTL": {
        "displayName": {
        },
        "narrow": "Lt",
        "symbol": "LTL"
      },
      "LVL": {
        "displayName": {
        },
        "narrow": "Ls",
        "symbol": "LVL"
      },
      "LYD": {
        "displayName": {
          "other": "ᎵᏈᏯ ᎠᏕᎳ"
        },
        "narrow": "LYD",
        "symbol": "LYD"
      },
      "MAD": {
        "displayName": {
          "other": "ᎼᎶᎪ ᎠᏕᎳ"
        },
        "narrow": "MAD",
        "symbol": "MAD"
      },
      "MDL": {
        "displayName": {
          "other": "ᎹᎵᏙᏫᎠ ᎠᏕᎳ"
        },
        "narrow": "MDL",
        "symbol": "MDL"
      },
      "MGA": {
        "displayName": {
          "other": "ᎹᎳᎦᏏ ᎠᏕᎳ"
        },
        "narrow": "Ar",
        "symbol": "MGA"
      },
      "MKD": {
        "displayName": {
          "other": "ᎹᏎᏙᏂᎠ ᎠᏕᎳ"
        },
        "narrow": "MKD",
        "symbol": "MKD"
      },
      "MMK": {
        "displayName": {
          "other": "ᎹᏯᎹᎵ ᎠᏕᎳ"
        },
        "narrow": "K",
        "symbol": "MMK"
      },
      "MNT": {
        "displayName": {
          "other": "ᎹᏂᎪᎵᎠ ᎠᏕᎳ"
        },
        "narrow": "₮",
        "symbol": "MNT"
      },
      "MOP": {
        "displayName": {
          "other": "ᎹᎧᎣ ᎠᏕᎳ"
        },
        "narrow": "MOP",
        "symbol": "MOP"
      },
      "MRO": {
        "displayName": {
          "other": "ᎹᏈᏔᏂᎠ ᎠᏕᎳ (1973–2017)"
        },
        "narrow": "MRO",
        "symbol": "MRO"
      },
      "MRU": {
        "displayName": {
          "other": "ᎹᏈᏔᏂᎠ ᎠᏕᎳ"
        },
        "narrow": "MRU",
        "symbol": "MRU"
      },
      "MUR": {
        "displayName": {
          "other": "ᎹᏘᎢᏯ ᎠᏕᎳ"
        },
        "narrow": "Rs",
        "symbol": "MUR"
      },
      "MVR": {
        "displayName": {
          "other": "ᎹᎵᏗᏫᏍ ᎠᏕᎳ"
        },
        "narrow": "MVR",
        "symbol": "MVR"
      },
      "MWK": {
        "displayName": {
          "other": "ᎹᎳᏫ ᎠᏕᎳ"
        },
        "narrow": "MWK",
        "symbol": "MWK"
      },
      "MXN": {
        "displayName": {
          "other": "ᏍᏆᏂ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "MX$"
      },
      "MYR": {
        "displayName": {
          "other": "ᎹᎴᏏᎢᎠ ᎠᏕᎳ"
        },
        "narrow": "RM",
        "symbol": "MYR"
      },
      "MZN": {
        "displayName": {
          "other": "ᎼᏎᎻᏇᎩ ᎠᏕᎳ"
        },
        "narrow": "MZN",
        "symbol": "MZN"
      },
      "NAD": {
        "displayName": {
          "other": "ᎾᎻᏈᎢᏯ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "NAD"
      },
      "NGN": {
        "displayName": {
          "other": "ᏂᏥᎵᏯ ᎠᏕᎳ"
        },
        "narrow": "₦",
        "symbol": "NGN"
      },
      "NIO": {
        "displayName": {
          "other": "ᏂᎧᎳᏆ ᎠᏕᎳ"
        },
        "narrow": "C$",
        "symbol": "NIO"
      },
      "NOK": {
        "displayName": {
          "other": "ᏃᏪ ᎠᏕᎳ"
        },
        "narrow": "kr",
        "symbol": "NOK"
      },
      "NPR": {
        "displayName": {
          "other": "ᏁᏆᎵ ᎠᏕᎳ"
        },
        "narrow": "Rs",
        "symbol": "NPR"
      },
      "NZD": {
        "displayName": {
          "other": "ᎢᏤ ᏏᎢᎴᏂᏗ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "NZ$"
      },
      "OMR": {
        "displayName": {
          "other": "ᎣᎺᏂ ᎠᏕᎳ"
        },
        "narrow": "OMR",
        "symbol": "OMR"
      },
      "PAB": {
        "displayName": {
          "other": "ᏆᎾᎹ ᎠᏕᎳ"
        },
        "narrow": "PAB",
        "symbol": "PAB"
      },
      "PEN": {
        "displayName": {
          "other": "ᏇᎷ ᎠᏕᎳ"
        },
        "narrow": "PEN",
        "symbol": "PEN"
      },
      "PGK": {
        "displayName": {
          "other": "ᏆᏇ ᎢᏤ ᎩᎢᏂ ᎠᏕᎳ"
        },
        "narrow": "PGK",
        "symbol": "PGK"
      },
      "PHP": {
        "displayName": {
          "other": "ᎠᏂᏈᎵᎩᏃ ᎠᏕᎳ"
        },
        "narrow": "₱",
        "symbol": "PHP"
      },
      "PKR": {
        "displayName": {
          "other": "ᏆᎩᏍᏖᏂ ᎠᏕᎳ"
        },
        "narrow": "Rs",
        "symbol": "PKR"
      },
      "PLN": {
        "displayName": {
          "other": "ᏉᎳᏂ ᎠᏕᎳ"
        },
        "narrow": "zł",
        "symbol": "PLN"
      },
      "PYG": {
        "displayName": {
          "other": "ᏆᎳᏇᎢᏯ ᎠᏕᎳ"
        },
        "narrow": "₲",
        "symbol": "PYG"
      },
      "QAR": {
        "displayName": {
          "other": "ᎧᏔᎵ ᎠᏕᎳ"
        },
        "narrow": "QAR",
        "symbol": "QAR"
      },
      "RON": {
        "displayName": {
          "other": "ᎶᎹᏂᏯ ᎠᏕᎳ"
        },
        "narrow": "lei",
        "symbol": "RON"
      },
      "RSD": {
        "displayName": {
          "other": "ᏒᏈᏯ ᎠᏕᎳ"
        },
        "narrow": "RSD",
        "symbol": "RSD"
      },
      "RUB": {
        "displayName": {
          "other": "ᏲᏂᎢ ᎠᏕᎳ"
        },
        "narrow": "₽",
        "symbol": "RUB"
      },
      "RWF": {
        "displayName": {
          "other": "ᎶᏩᏂᏓ ᎠᏕᎳ"
        },
        "narrow": "RF",
        "symbol": "RWF"
      },
      "SAR": {
        "displayName": {
          "other": "ᏌᎤᏗ ᎠᏕᎳ"
        },
        "narrow": "SAR",
        "symbol": "SAR"
      },
      "SBD": {
        "displayName": {
          "other": "ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "SBD"
      },
      "SCR": {
        "displayName": {
          "other": "ᏏᎡᏥᎵᏍ ᎠᏕᎳ"
        },
        "narrow": "SCR",
        "symbol": "SCR"
      },
      "SDG": {
        "displayName": {
          "other": "ᏑᏕᏂ ᎠᏕᎳ"
        },
        "narrow": "SDG",
        "symbol": "SDG"
      },
      "SEK": {
        "displayName": {
          "other": "ᏍᏫᏕᏂ ᎠᏕᎳ"
        },
        "narrow": "kr",
        "symbol": "SEK"
      },
      "SGD": {
        "displayName": {
          "other": "ᏏᏂᎦᏉᎵ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "SGD"
      },
      "SHP": {
        "displayName": {
          "other": "ᎤᏓᏅᏘ ᎮᎵᎾ ᎠᏕᎳ"
        },
        "narrow": "£",
        "symbol": "SHP"
      },
      "SLE": {
        "displayName": {
          "other": "ᏏᎡᎳᎴᎣᏂ ᎠᏕᎳ"
        },
        "narrow": "SLE",
        "symbol": "SLE"
      },
      "SLL": {
        "displayName": {
          "other": "ᏏᎡᎳᎴᎣᏂ ᎠᏕᎳ (1964—2022)"
        },
        "narrow": "SLL",
        "symbol": "SLL"
      },
      "SOS": {
        "displayName": {
          "other": "ᏐᎹᎵ ᎠᏕᎳ"
        },
        "narrow": "SOS",
        "symbol": "SOS"
      },
      "SRD": {
        "displayName": {
          "other": "ᏒᎵᎾᎻ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "SRD"
      },
      "SSP": {
        "displayName": {
          "other": "ᏧᎦᎾᏮ ᏑᏕᏂ ᎠᏕᎳ"
        },
        "narrow": "£",
        "symbol": "SSP"
      },
      "STD": {
        "displayName": {
          "other": "ᏌᎣᏙᎺ ᎠᎴ ᏈᏂᏏᏇ ᎠᏕᎳ (1977–2017)"
        },
        "narrow": "STD",
        "symbol": "STD"
      },
      "STN": {
        "displayName": {
          "other": "ᏌᎣᏙᎺ & ᏈᏂᏏᏇ ᎠᏕᎳ"
        },
        "narrow": "Db",
        "symbol": "STN"
      },
      "SYP": {
        "displayName": {
          "other": "ᏏᎵᎠ ᎠᏕᎳ"
        },
        "narrow": "£",
        "symbol": "SYP"
      },
      "SZL": {
        "displayName": {
          "other": "ᏍᏩᏏ ᎠᏕᎳ"
        },
        "narrow": "SZL",
        "symbol": "SZL"
      },
      "THB": {
        "displayName": {
          "other": "ᏔᏯᎴᏂ ᎠᏕᎳ"
        },
        "narrow": "฿",
        "symbol": "THB"
      },
      "TJS": {
        "displayName": {
          "other": "ᏔᏥᎩᏍᏕᏂ ᎠᏕᎳ"
        },
        "narrow": "TJS",
        "symbol": "TJS"
      },
      "TMT": {
        "displayName": {
          "other": "ᏛᎵᎩᎺᏂᏍᏔᏂ ᎠᏕᎳ"
        },
        "narrow": "TMT",
        "symbol": "TMT"
      },
      "TND": {
        "displayName": {
          "other": "ᏚᏂᏏᏍᎠ ᎠᏕᎳ"
        },
        "narrow": "TND",
        "symbol": "TND"
      },
      "TOP": {
        "displayName": {
          "other": "ᏔᏂᎪ ᎠᏕᎳ"
        },
        "narrow": "T$",
        "symbol": "TOP"
      },
      "TRY": {
        "displayName": {
          "other": "ᎬᏃ ᎠᏕᎳ"
        },
        "narrow": "₺",
        "symbol": "TRY"
      },
      "TTD": {
        "displayName": {
          "other": "ᏟᏂᏕᏗ & ᏙᏆᎪ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "TTD"
      },
      "TWD": {
        "displayName": {
          "other": "ᎢᏤ ᏔᎢᏩᏂ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "NT$"
      },
      "TZS": {
        "displayName": {
          "other": "ᏖᏂᏏᏂᏯ ᎠᏕᎳ"
        },
        "narrow": "TZS",
        "symbol": "TZS"
      },
      "UAH": {
        "displayName": {
          "other": "ᏳᎧᎴᏂ ᎠᏕᎳ"
        },
        "narrow": "₴",
        "symbol": "UAH"
      },
      "UGX": {
        "displayName": {
          "other": "ᏳᎦᏂᏓ ᎠᏕᎳ"
        },
        "narrow": "UGX",
        "symbol": "UGX"
      },
      "USD": {
        "displayName": {
          "other": "US ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "$"
      },
      "UYU": {
        "displayName": {
          "other": "ᏳᎷᏇ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "UYU"
      },
      "UZS": {
        "displayName": {
          "other": "ᎤᏍᏇᎩᏍᏖᏂ ᎠᏕᎳ"
        },
        "narrow": "UZS",
        "symbol": "UZS"
      },
      "VEF": {
        "displayName": {
          "other": "ᏪᏁᏑᏪᎳ ᎠᏕᎳ"
        },
        "narrow": "Bs",
        "symbol": "VEF"
      },
      "VES": {
        "displayName": {
          "other": "ᏪᏁᏑᏪ ᎠᏕᎳ"
        },
        "narrow": "VES",
        "symbol": "VES"
      },
      "VND": {
        "displayName": {
          "other": "ᏫᎡᏘᎾᎻᏍ ᎠᏕᎳ"
        },
        "narrow": "₫",
        "symbol": "₫"
      },
      "VUV": {
        "displayName": {
          "other": "ᏩᏂᎤᏩᏚ ᎠᏕᎳ"
        },
        "narrow": "VUV",
        "symbol": "VUV"
      },
      "WST": {
        "displayName": {
          "other": "ᏌᎼᎠ ᎠᏕᎳ"
        },
        "narrow": "WST",
        "symbol": "WST"
      },
      "XAF": {
        "displayName": {
          "other": "ᎠᏰᏟ ᎬᎿᎨᏍᏛ CFA ᎠᏕᎳ"
        },
        "narrow": "FCFA",
        "symbol": "FCFA"
      },
      "XCD": {
        "displayName": {
          "other": "ᏗᎧᎸᎬ ᎨᏆᏙᏯ ᎠᏕᎳ"
        },
        "narrow": "$",
        "symbol": "EC$"
      },
      "XCG": {
        "displayName": {
        },
        "narrow": "Cg.",
        "symbol": "Cg."
      },
      "XOF": {
        "displayName": {
          "other": "ᏭᏕᎵᎬ ᎬᎿᎨᏍᏛ CFA ᎠᏕᎳ"
        },
        "narrow": "F CFA",
        "symbol": "F CFA"
      },
      "XPF": {
        "displayName": {
          "other": "CFP ᎠᏕᎳ"
        },
        "narrow": "CFPF",
        "symbol": "CFPF"
      },
      "XXX": {
        "displayName": {
          "other": "(ᏄᏬᎵᏍᏛᎾ ᎠᏕᎳ)"
        },
        "narrow": "¤",
        "symbol": "¤"
      },
      "YER": {
        "displayName": {
          "other": "ᏰᎺᏂ ᎠᏕᎳ"
        },
        "narrow": "YER",
        "symbol": "YER"
      },
      "ZAR": {
        "displayName": {
          "other": "ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ ᎠᏕᎳ"
        },
        "narrow": "R",
        "symbol": "ZAR"
      },
      "ZMW": {
        "displayName": {
          "other": "ᏏᎻᏆᏇ ᎠᏕᎳ"
        },
        "narrow": "ZK",
        "symbol": "ZMW"
      }
    },
    "nu": [
      "latn"
    ],
    "numbers": {
      "currency": {
        "latn": {
          "accounting": "¤#,##0.00;(¤#,##0.00)",
          "currencySpacing": {
            "afterInsertBetween": " ",
            "beforeInsertBetween": " "
          },
          "short": {
            "1000": {
              "other": "¤0K"
            },
            "10000": {
              "other": "¤00K"
            },
            "100000": {
              "other": "¤000K"
            },
            "1000000": {
              "other": "¤0M"
            },
            "10000000": {
              "other": "¤00M"
            },
            "100000000": {
              "other": "¤000M"
            },
            "1000000000": {
              "other": "¤0B"
            },
            "10000000000": {
              "other": "¤00B"
            },
            "100000000000": {
              "other": "¤000B"
            },
            "1000000000000": {
              "other": "¤0T"
            },
            "10000000000000": {
              "other": "¤00T"
            },
            "100000000000000": {
              "other": "¤000T"
            }
          },
          "standard": "¤#,##0.00",
          "unitPattern": "{0} {1}"
        }
      },
      "decimal": {
        "latn": {
          "long": {
            "1000": {
              "other": "0 ᎢᏯᎦᏴᎵ"
            },
            "10000": {
              "other": "00 ᎢᏯᎦᏴᎵ"
            },
            "100000": {
              "other": "000 ᎢᏯᎦᏴᎵ"
            },
            "1000000": {
              "other": "0 ᎢᏳᏆᏗᏅᏛ"
            },
            "10000000": {
              "other": "00 ᎢᏳᏆᏗᏅᏛ"
            },
            "100000000": {
              "other": "000 ᎢᏳᏆᏗᏅᏛ"
            },
            "1000000000": {
              "other": "0 ᎢᏯᏔᎳᏗᏅᏛ"
            },
            "10000000000": {
              "other": "00 ᎢᏯᏔᎳᏗᏅᏛ"
            },
            "100000000000": {
              "other": "000 ᎢᏯᏔᎳᏗᏅᏛ"
            },
            "1000000000000": {
              "other": "0 ᎢᏯᏦᎠᏗᏅᏛ"
            },
            "10000000000000": {
              "other": "00 ᎢᏯᏦᎠᏗᏅᏛ"
            },
            "100000000000000": {
              "other": "000 ᎢᏯᏦᎠᏗᏅᏛ"
            }
          },
          "short": {
            "1000": {
              "other": "0K"
            },
            "10000": {
              "other": "00K"
            },
            "100000": {
              "other": "000K"
            },
            "1000000": {
              "other": "0M"
            },
            "10000000": {
              "other": "00M"
            },
            "100000000": {
              "other": "000M"
            },
            "1000000000": {
              "other": "0B"
            },
            "10000000000": {
              "other": "00B"
            },
            "100000000000": {
              "other": "000B"
            },
            "1000000000000": {
              "other": "0T"
            },
            "10000000000000": {
              "other": "00T"
            },
            "100000000000000": {
              "other": "000T"
            }
          },
          "standard": "#,##0.###"
        }
      },
      "nu": [
        "latn"
      ],
      "percent": {
        "latn": "#,##0%"
      },
      "symbols": {
        "latn": {
          "approximatelySign": "~",
          "decimal": ".",
          "exponential": "E",
          "group": ",",
          "infinity": "∞",
          "list": ";",
          "minusSign": "-",
          "nan": "NaN",
          "perMille": "‰",
          "percentSign": "%",
          "plusSign": "+",
          "rangeSign": "–",
          "superscriptingExponent": "×",
          "timeSeparator": ":"
        }
      }
    },
    "units": {
      "compound": {
        "per": {
          "long": "{0} ᎾᎿ {1}",
          "narrow": "{0}/{1}",
          "short": "{0}/{1}"
        }
      },
      "simple": {
        "acre": {
          "long": {
            "one": "{0} ᏑᏟᎶᏓᎢ",
            "other": "{0} ᎢᏧᏟᎶᏓ"
          },
          "narrow": {
            "other": "{0}ac"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ᏑᏟᎶ"
          }
        },
        "bit": {
          "long": {
            "one": "{0} ᎤᏍᎦᎳ",
            "other": "{0} ᎤᏍᎦᎵᏨ"
          },
          "narrow": {
            "other": "{0}ᎤᏍᎦᎳ"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ᎤᏍᎦᎳ"
          }
        },
        "byte": {
          "long": {
            "one": "{0} ᎠᏍᎦᎳ",
            "other": "{0} ᏗᏓᏍᎦᎵᎩ"
          },
          "narrow": {
            "other": "{0}B"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ᎠᏍᎦᎳ"
          }
        },
        "celsius": {
          "long": {
            "one": "{0} ᎢᎦᎢ ᎢᎦ ᎠᏤ ᎠᏟᎶᏍᏙᏗ",
            "other": "{0} ᎢᎦᎢ ᎢᏗᎦᏘ ᎠᏤ ᎠᏟᎶᏍᏙᏗ"
          },
          "narrow": {
            "other": "{0}°C"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0}°C"
          }
        },
        "centimeter": {
          "long": {
            "one": "{0} ᎤᏍᏗ ᎠᏟᎶᏗ",
            "other": "{0} ᏧᏍᏗ ᏗᏟᎶᏗ"
          },
          "narrow": {
            "other": "{0}cm"
          },
          "perUnit": {
            "long": "{0} ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ",
            "narrow": "{0}/cm",
            "short": "{0}/cm"
          },
          "short": {
            "other": "{0} cm"
          }
        },
        "day": {
          "long": {
            "one": "{0} ᎢᎦ",
            "other": "{0} ᎯᎸᏍᎩ ᏧᏒᎯᏓ"
          },
          "narrow": {
            "other": "{0}Ꭲ"
          },
          "perUnit": {
            "long": "{0} ᎢᎦ ᎢᏳᏓᎵ",
            "narrow": "{0}/Ꭲ",
            "short": "{0}/Ꭲ"
          },
          "short": {
            "one": "{0} ᎢᎦ",
            "other": "{0} ᏧᏒᎯᏓ"
          }
        },
        "degree": {
          "long": {
            "one": "{0} ᎢᎦᎢ ᎢᎦ",
            "other": "{0} ᎢᎦᎢ ᎢᏗᎦᏘ"
          },
          "narrow": {
            "other": "{0}°"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} deg"
          }
        },
        "fahrenheit": {
          "long": {
            "one": "ᎢᎦᎢ ᎢᎦ ᏅᎦᏃᏋ ᎠᎴ ᏅᏴᏢ ᎠᏟᎶᏍᏙᏗ",
            "other": "{0} ᎢᎦᎢ ᎢᏗᎦᏘ ᏅᎦᏃᏋ ᎠᎴ ᏅᏴᏢ ᎠᏟᎶᏍᏙᏗ"
          },
          "narrow": {
            "other": "{0}°"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0}°F"
          }
        },
        "fluid-ounce": {
          "long": {
            "one": "{0} ᎤᏓᏁᎯ ᎣᏂᏏ",
            "other": "{0} ᎤᏓᏁᎯ ᎢᏯᎣᏂᏏ"
          },
          "narrow": {
            "other": "{0}fl oz"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} fl oz"
          }
        },
        "foot": {
          "long": {
            "one": "{0} ᎢᎳᏏᏗ",
            "other": "{0} ᎢᏗᎳᏏᏗ"
          },
          "narrow": {
            "other": "{0}′"
          },
          "perUnit": {
            "long": "{0} ᎢᎳᏏᏗ ᎢᏳᏓᎵ",
            "narrow": "{0}/ft",
            "short": "{0}/ft"
          },
          "short": {
            "other": "{0} ft"
          }
        },
        "gallon": {
          "long": {
            "one": "{0} ᎢᏳᎵᎶᏓ",
            "other": "{0} ᎢᏧᎵᎶᏓ"
          },
          "narrow": {
            "other": "{0}gal"
          },
          "perUnit": {
            "long": "{0} ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ",
            "narrow": "{0}/gal",
            "short": "{0}/gal US"
          },
          "short": {
            "other": "{0} gal"
          }
        },
        "gigabit": {
          "long": {
            "one": "{0} ᎩᎦᎤᏍᎦᎳ",
            "other": "{0} ᎩᎦᎤᏍᎦᎵᏨ"
          },
          "narrow": {
            "other": "{0}Gb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} Gb"
          }
        },
        "gigabyte": {
          "long": {
            "one": "{0} ᎩᎦᎠᏍᎦᎳ",
            "other": "{0} ᎩᎦᏗᏓᏍᎦᎵᎩ"
          },
          "narrow": {
            "other": "{0}GB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} GB"
          }
        },
        "gram": {
          "long": {
            "one": "{0} ᎤᏍᏗ ᎤᏓᎨᏒ",
            "other": "{0} ᎤᏍᏗ ᏂᏚᏓᎨᏒ"
          },
          "narrow": {
            "other": "{0}g"
          },
          "perUnit": {
            "long": "{0} ᎤᏍᏗ ᎤᏓᎨᏒ ᎢᏳᏓᎵ",
            "narrow": "{0}/g",
            "short": "{0}/g"
          },
          "short": {
            "other": "{0} g"
          }
        },
        "hectare": {
          "long": {
            "one": "{0} ᎮᏔ ᏑᏟᎶᏛ",
            "other": "{0} ᎮᏔ ᎢᏳᏟᎶᏛ"
          },
          "narrow": {
            "other": "{0}ha"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ha"
          }
        },
        "hour": {
          "long": {
            "one": "{0} ᏑᏟᎶᏓ",
            "other": "{0} ᎢᏳᏟᎶᏓ"
          },
          "narrow": {
            "other": "{0}Ꮡ"
          },
          "perUnit": {
            "long": "{0} ᏑᏟᎶᏓ ᎢᏳᏓᎵ",
            "narrow": "{0}/Ꮡ",
            "short": "{0}/Ꮡ"
          },
          "short": {
            "other": "{0} ᏑᏟ"
          }
        },
        "inch": {
          "long": {
            "one": "{0} ᎢᏏᏔᏗᏍᏗ",
            "other": "{0} ᎢᏗᏏᏔᏗᏍᏗ"
          },
          "narrow": {
            "other": "{0}″"
          },
          "perUnit": {
            "long": "{0} ᎢᏏᏔᏗᏍᏗ ᎢᏳᏓᎵ",
            "narrow": "{0}/in",
            "short": "{0}/in"
          },
          "short": {
            "other": "{0} in"
          }
        },
        "kilobit": {
          "long": {
            "one": "{0} ᎠᎦᏴᎵ ᎤᏍᎦᎳ",
            "other": "{0} ᎠᎦᏴᎵ ᎤᏍᎦᎵᏨ"
          },
          "narrow": {
            "other": "{0}kb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} kb"
          }
        },
        "kilobyte": {
          "long": {
            "one": "{0} ᎠᎦᏴᎵ ᎠᏍᎦᎳ",
            "other": "{0} ᎠᎦᏴᎵ ᏗᏓᏍᎦᎵᎩ"
          },
          "narrow": {
            "other": "{0}kB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} kB"
          }
        },
        "kilogram": {
          "long": {
            "one": "{0} ᎠᎦᏴᎵ ᎤᏍᏗ ᎤᏓᎨᏒ",
            "other": "{0} ᎠᎦᏴᎵ ᎤᏍᏗ ᏂᏚᏓᎨᏒ"
          },
          "narrow": {
            "other": "{0}kg"
          },
          "perUnit": {
            "long": "{0} ᎠᎦᏴᎵ ᎤᏍᏗ ᎤᏓᎨᏒ ᎢᏳᏓᎵ",
            "narrow": "{0}/kg",
            "short": "{0}/kg"
          },
          "short": {
            "other": "{0} kg"
          }
        },
        "kilometer": {
          "long": {
            "one": "{0} ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ",
            "other": "{0} ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ"
          },
          "narrow": {
            "other": "{0}ᎠᏗ"
          },
          "perUnit": {
            "long": "{0} ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ",
            "narrow": "{0}/ᎠᏗ",
            "short": "{0}/ᎠᏗ"
          },
          "short": {
            "other": "{0} ᎠᏗ"
          }
        },
        "kilometer-per-hour": {
          "long": {
            "one": "{0} ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᏑᏟᎶᏓ ᎢᏳᏓᎵ",
            "other": "{0} ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ ᏑᏟᎶᏓ ᎢᏳᏓᎵ"
          },
          "narrow": {
            "other": "{0}km/h"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} km/h"
          }
        },
        "liter": {
          "long": {
            "one": "{0} ᎢᏳᏆᏗᏅᏛ",
            "other": "{0} ᎢᏧᏆᏗᏅᏛ"
          },
          "narrow": {
            "other": "{0}L"
          },
          "perUnit": {
            "long": "{0} ᎢᏳᏆᏗᏅᏛ ᎢᏳᏓᎵ",
            "narrow": "{0}/L",
            "short": "{0}/l"
          },
          "short": {
            "other": "{0} L"
          }
        },
        "liter-per-kilometer": {
          "long": {
            "one": "{0} ᎵᏔᎢ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ",
            "other": "{0} ᏗᎵᏔᎢ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ"
          },
          "narrow": {
            "other": "{0}L/km"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} L/km"
          }
        },
        "megabit": {
          "long": {
            "one": "{0} ᎺᎦ ᎤᏍᎦᎳ",
            "other": "{0} ᎺᎦ ᎤᏍᎦᎵᏨ"
          },
          "narrow": {
            "other": "{0}Mb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} Mb"
          }
        },
        "megabyte": {
          "long": {
            "one": "{0} ᎺᎦ ᎠᏍᎦᎳ",
            "other": "{0} ᎺᎦ ᏗᏓᏍᎦᎵᎩ"
          },
          "narrow": {
            "other": "{0}MB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} MB"
          }
        },
        "meter": {
          "long": {
            "one": "{0} ᎠᏟᎶᏍᏗ",
            "other": "{0} ᏗᏟᎶᏍᏗ"
          },
          "narrow": {
            "other": "{0}ᎠᏟ"
          },
          "perUnit": {
            "long": "{0} ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ",
            "narrow": "{0}/ᎠᏟ",
            "short": "{0}/ᎠᏟ"
          },
          "short": {
            "other": "{0} ᎠᏟ"
          }
        },
        "meter-per-second": {
          "long": {
            "one": "{0} ᎠᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ",
            "other": "{0} ᏗᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ"
          },
          "narrow": {
            "other": "{0}m/s"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} m/s"
          }
        },
        "mile": {
          "long": {
            "one": "{0} ᏑᏟᎶᏓ",
            "other": "{0} ᎢᏳᏟᎶᏓ"
          },
          "narrow": {
            "other": "{0}mi"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mi"
          }
        },
        "mile-per-gallon": {
          "long": {
            "one": "{0} ᏑᏟᎶᏓ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ",
            "other": "{0} ᎢᏧᏟᎶᏓ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ"
          },
          "narrow": {
            "other": "{0}mpg"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mpg"
          }
        },
        "mile-per-hour": {
          "long": {
            "one": "{0} ᏑᏟᎶᏓ ᏑᏟᎶᏛ ᎢᏳᏓᎵ",
            "other": "{0} ᎢᏧᏟᎶᏓ ᏑᏟᎶᏛ ᎢᏳᏓᎵ"
          },
          "narrow": {
            "other": "{0}mph"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mph"
          }
        },
        "mile-scandinavian": {
          "long": {
            "one": "{0} ᏑᏟᎶᏓ-ᏍᎦᎾᏗᎾᏫᎠᏂ",
            "other": "{0} ᎢᏳᏟᎶᏓ-ᏍᎦᎾᏗᎾᏫᎠᏂ"
          },
          "narrow": {
            "other": "{0}smi"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} smi"
          }
        },
        "milliliter": {
          "long": {
            "one": "{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎵᏔᎢ",
            "other": "{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᎵᏔᎵ"
          },
          "narrow": {
            "other": "{0}mL"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} mL"
          }
        },
        "millimeter": {
          "long": {
            "one": "ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏟᎶᏍᏗ",
            "other": "{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏍᏗ"
          },
          "narrow": {
            "other": "{0}ᏌᎢᎠ"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ᏌᎢᎠ"
          }
        },
        "millisecond": {
          "long": {
            "one": "{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏎᏢ",
            "other": "{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏎᏢ"
          },
          "narrow": {
            "other": "{0}ᏌᎠ"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} ᏌᎠ"
          }
        },
        "minute": {
          "long": {
            "other": "{0} ᎢᏯᏔᏬᏍᏔᏅ"
          },
          "narrow": {
            "other": "{0}Ꭲ"
          },
          "perUnit": {
            "long": "{0} ᎢᏯᏔᏬᏍᏔᏅ ᎢᏳᏓᎵ",
            "narrow": "{0}/ᎢᏯᏔ",
            "short": "{0}/ᎢᏯᏔ"
          },
          "short": {
            "other": "{0} ᎢᏯᏔ"
          }
        },
        "month": {
          "long": {
            "one": "{0} ᎧᎸᎢ",
            "other": "{0} ᏗᎧᎸᎢ"
          },
          "narrow": {
            "other": "{0}Ꭷ"
          },
          "perUnit": {
            "long": "{0} ᎧᎸᎢ ᎢᏳᏓᎵ",
            "narrow": "{0}/Ꭷ",
            "short": "{0}/Ꭷ"
          },
          "short": {
            "one": "{0} ᎧᎸᎢ",
            "other": "{0} ᏗᎧᎸᎢ"
          }
        },
        "ounce": {
          "long": {
            "one": "{0} ᎣᏂᏏ",
            "other": "{0} ᎢᏯᎣᏂᏏ"
          },
          "narrow": {
            "other": "{0}oz"
          },
          "perUnit": {
            "long": "{0} ᎣᏂᏏ ᎢᏳᏓᎵ",
            "narrow": "{0}/oz",
            "short": "{0}/oz"
          },
          "short": {
            "other": "{0} oz"
          }
        },
        "percent": {
          "long": {
            "other": "{0} ᏓᎬᏩᎶᏛ"
          },
          "narrow": {
            "other": "{0}%"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0}%"
          }
        },
        "petabyte": {
          "long": {
            "other": "{0} ᏇᏔ ᏗᏓᏍᎦᎵᎩ"
          },
          "narrow": {
            "other": "{0}PB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} PB"
          }
        },
        "pound": {
          "long": {
            "one": "{0} ᏑᏓᎨᏓ",
            "other": "{0} ᎢᏧᏓᎨᏓ"
          },
          "narrow": {
            "other": "{0}#"
          },
          "perUnit": {
            "long": "{0} ᎢᏧᏓᎨᏓ ᎢᏳᏓᎵ",
            "narrow": "{0}/lb",
            "short": "{0}/lb"
          },
          "short": {
            "other": "{0} lb"
          }
        },
        "second": {
          "long": {
            "one": "{0} ᎠᏎᏢ",
            "other": "{0} ᏗᏎᏢ"
          },
          "narrow": {
            "other": "{0}ᎠᏎ"
          },
          "perUnit": {
            "long": "{0} ᎠᏎᏢ ᎢᏳᏓᎵ",
            "narrow": "{0}/ᎠᏎ",
            "short": "{0}/ᎠᏎ"
          },
          "short": {
            "other": "{0} ᎠᏎᏢ"
          }
        },
        "stone": {
          "long": {
            "one": "{0} ᏅᏯ",
            "other": "{0} ᎠᏂᏅᏯ"
          },
          "narrow": {
            "other": "{0}st"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} st"
          }
        },
        "terabit": {
          "long": {
            "one": "ᏕᎳ ᎤᏍᎦᎳ",
            "other": "{0} ᏕᎳ ᎤᏍᎦᎵᏨ"
          },
          "narrow": {
            "other": "{0}Tb"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} Tb"
          }
        },
        "terabyte": {
          "long": {
            "one": "{0} ᏕᎳ ᎠᏍᎦᎳ",
            "other": "{0} ᏕᎳ ᏗᏓᏍᎦᎵᎩ"
          },
          "narrow": {
            "other": "{0}TB"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} TB"
          }
        },
        "week": {
          "long": {
            "one": "{0} ᏒᎾᏙᏓᏆᏍᏗ",
            "other": "{0} ᎢᏳᎾᏙᏓᏆᏍᏗ"
          },
          "narrow": {
            "other": "{0}Ꮢ"
          },
          "perUnit": {
            "long": "{0} ᏒᎾᏙᏓᏆᏍᏗ ᎢᏳᏓᎵ",
            "narrow": "{0}/Ꮢ",
            "short": "{0}/Ꮢ"
          },
          "short": {
            "one": "{0} ᏒᎾ",
            "other": "{0} ᎢᏳᎾ"
          }
        },
        "yard": {
          "long": {
            "one": "{0} ᏯᏗ",
            "other": "{0} ᎢᏯᏯᏗ"
          },
          "narrow": {
            "other": "{0}yd"
          },
          "perUnit": {
          },
          "short": {
            "other": "{0} yd"
          }
        },
        "year": {
          "long": {
            "one": "{0} ᎤᏕᏘᏴᏌᏗᏒᎢ",
            "other": "{0} ᏧᏕᏘᏴᏌᏗᏒᎢ"
          },
          "narrow": {
            "other": "{0}Ꭴ"
          },
          "perUnit": {
            "long": "{0} ᎤᏕᏘᏴᏌᏗᏒᎢ ᎢᏳᏓᎵ",
            "narrow": "{0}/Ꭴ",
            "short": "{0}/Ꭴ"
          },
          "short": {
            "one": "{0} ᎤᏕ",
            "other": "{0} ᏧᏕ"
          }
        }
      }
    }
  },
  "locale": "chr"
})
}