// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
import { SpanStatusCode } from "@opentelemetry/api";
export class OpenTelemetrySpanWrapper {
    constructor(span) {
        this._span = span;
    }
    setStatus(status) {
        if (status.status === "error") {
            if (status.error) {
                this._span.setStatus({ code: SpanStatusCode.ERROR, message: status.error.toString() });
                this.recordException(status.error);
            }
            else {
                this._span.setStatus({ code: SpanStatusCode.ERROR });
            }
        }
        else if (status.status === "success") {
            this._span.setStatus({ code: SpanStatusCode.OK });
        }
    }
    setAttribute(name, value) {
        if (value !== null && value !== undefined) {
            this._span.setAttribute(name, value);
        }
    }
    end() {
        this._span.end();
    }
    recordException(exception) {
        this._span.recordException(exception);
    }
    isRecording() {
        return this._span.isRecording();
    }
    /**
     * Allows getting the wrapped span as needed.
     * @internal
     *
     * @returns The underlying span
     */
    unwrap() {
        return this._span;
    }
}
//# sourceMappingURL=spanWrapper.js.map