"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveRnwCliRoot = exports.resolveRnwRoot = exports.resolveRnCliRoot = exports.resolveRnRoot = void 0;
const path_1 = __importDefault(require("path"));
function resolveRnRoot(paths) {
    return path_1.default.dirname(require.resolve('react-native/package.json', {
        paths: typeof paths === 'string' ? [paths] : paths,
    }));
}
exports.resolveRnRoot = resolveRnRoot;
function resolveRnCliRoot(paths) {
    return path_1.default.dirname(require.resolve('@react-native-community/cli/package.json', {
        paths: typeof paths === 'string' ? [paths] : paths,
    }));
}
exports.resolveRnCliRoot = resolveRnCliRoot;
function resolveRnwRoot(paths) {
    return path_1.default.dirname(require.resolve('react-native-windows/package.json', {
        paths: typeof paths === 'string' ? [paths] : paths,
    }));
}
exports.resolveRnwRoot = resolveRnwRoot;
function resolveRnwCliRoot(paths) {
    return path_1.default.dirname(require.resolve('@react-native-windows/cli/package.json', {
        paths: typeof paths === 'string' ? [paths] : paths,
    }));
}
exports.resolveRnwCliRoot = resolveRnwCliRoot;
//# sourceMappingURL=pathHelpers.js.map