"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureExperimentalNuGetProject = exports.ensureHermesProject = exports.ensureWinUI3Project = exports.ensureCSharpAppProject = exports.ensureCppAppProject = exports.tryMkdir = exports.testProjectGuid = exports.templateRoot = void 0;
const fs_1 = __importDefault(require("@react-native-windows/fs"));
const path_1 = __importDefault(require("path"));
const generator_common_1 = require("../generator-common");
exports.templateRoot = path_1.default.resolve('../../../vnext/template');
exports.testProjectGuid = '{416476D5-974A-4EE2-8145-4E331297247E}';
async function tryMkdir(dir) {
    try {
        await fs_1.default.mkdir(dir, { recursive: true });
    }
    catch (err) { }
}
exports.tryMkdir = tryMkdir;
async function ensureCppAppProject(folder, name, useWinUI3, useHermes, useExperimentalNuget) {
    const windowsDir = path_1.default.join(folder, 'windows');
    if (fs_1.default.existsSync(windowsDir)) {
        await fs_1.default.rmdir(windowsDir, { recursive: true });
    }
    await tryMkdir(windowsDir);
    const replacements = {
        name,
        namespace: name,
        useMustache: true,
        projectGuidUpper: exports.testProjectGuid,
        projectGuidLower: exports.testProjectGuid.toLowerCase(),
        useWinUI3: !!useWinUI3,
        useHermes: !!useHermes,
        useExperimentalNuget: !!useExperimentalNuget,
    };
    await (0, generator_common_1.copyAndReplace)(path_1.default.join(exports.templateRoot, 'cpp-app/proj/MyApp.sln'), path_1.default.join(windowsDir, `${name}.sln`), replacements, null);
    const projDir = path_1.default.join(windowsDir, name);
    await tryMkdir(projDir);
    await (0, generator_common_1.copyAndReplace)(path_1.default.join(exports.templateRoot, 'cpp-app/proj/MyApp.vcxproj'), path_1.default.join(projDir, `${name}.vcxproj`), replacements, null);
    await (0, generator_common_1.copyAndReplace)(path_1.default.join(exports.templateRoot, 'shared-app/proj/ExperimentalFeatures.props'), path_1.default.join(windowsDir, 'ExperimentalFeatures.props'), replacements, null);
}
exports.ensureCppAppProject = ensureCppAppProject;
async function ensureCSharpAppProject(folder, name, useWinUI3, useHermes, useExperimentalNuget) {
    const windowsDir = path_1.default.join(folder, 'windows');
    if (fs_1.default.existsSync(windowsDir)) {
        await fs_1.default.rmdir(windowsDir, { recursive: true });
    }
    await tryMkdir(windowsDir);
    const replacements = {
        name,
        namespace: name,
        useMustache: true,
        projectGuidUpper: exports.testProjectGuid,
        projectGuidLower: exports.testProjectGuid.toLowerCase(),
        useWinUI3: !!useWinUI3,
        useHermes: !!useHermes,
        useExperimentalNuget: !!useExperimentalNuget,
    };
    await (0, generator_common_1.copyAndReplace)(path_1.default.join(exports.templateRoot, 'cs-app/proj/MyApp.sln'), path_1.default.join(windowsDir, `${name}.sln`), replacements, null);
    const projDir = path_1.default.join(windowsDir, name);
    await tryMkdir(projDir);
    await (0, generator_common_1.copyAndReplace)(path_1.default.join(exports.templateRoot, 'cs-app/proj/MyApp.csproj'), path_1.default.join(projDir, `${name}.csproj`), replacements, null);
    await (0, generator_common_1.copyAndReplace)(path_1.default.join(exports.templateRoot, 'shared-app/proj/ExperimentalFeatures.props'), path_1.default.join(windowsDir, 'ExperimentalFeatures.props'), replacements, null);
}
exports.ensureCSharpAppProject = ensureCSharpAppProject;
async function ensureWinUI3Project(folder) {
    await ensureCppAppProject(folder, 'WithWinUI3', true, false, false);
}
exports.ensureWinUI3Project = ensureWinUI3Project;
async function ensureHermesProject(folder) {
    await ensureCppAppProject(folder, 'WithHermes', false, true, false);
}
exports.ensureHermesProject = ensureHermesProject;
async function ensureExperimentalNuGetProject(folder) {
    await ensureCppAppProject(folder, 'WithExperimentalNuGet', false, false, true);
}
exports.ensureExperimentalNuGetProject = ensureExperimentalNuGetProject;
//# sourceMappingURL=projectConfig.utils.js.map