"use strict";

const RNTurboLog = require('./NativeRNTurboLog').default;
export function configure(options = {}) {
  const opts = {
    dailyRolling: options.dailyRolling ?? false,
    maximumFileSize: options.maximumFileSize ?? 1024 * 1024,
    maximumNumberOfFiles: options.maximumNumberOfFiles ?? 5,
    logsDirectory: options.logsDirectory
  };
  return RNTurboLog.configure(opts);
}
export function deleteLogFiles() {
  return RNTurboLog.deleteLogFiles();
}
export function getLogFilePaths() {
  return RNTurboLog.getLogFilePaths();
}
export function write(logLevel, message) {
  RNTurboLog.write(logLevel, message);
}
//# sourceMappingURL=native.js.map