"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateUploadRequestOptions = exports.validateRequestOptions = exports.validateAPIClientConfiguration = void 0;
var z = _interopRequireWildcard(require("zod"));
var _NativeApiClient = require("./APIClient/NativeApiClient");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

const SessionConfigurationSchema = z.object({
  allowsCellularAccess: z.boolean().optional(),
  waitsForConnectivity: z.boolean().optional(),
  timeoutIntervalForRequest: z.number().optional(),
  timeoutIntervalForResource: z.number().optional(),
  httpMaximumConnectionsPerHost: z.number().optional(),
  cancelRequestsOnUnauthorized: z.boolean().optional(),
  trustSelfSignedServerCertificate: z.boolean().optional()
});
const RetryPolicyConfigurationSchema = z.object({
  type: z.enum(Object.values(_NativeApiClient.RetryTypes)).optional(),
  retryLimit: z.number().optional(),
  retryInterval: z.number().optional(),
  exponentialBackoffBase: z.number().optional(),
  exponentialBackoffScale: z.number().optional(),
  retryMethods: z.array(z.string()).optional(),
  statusCodes: z.array(z.number()).optional()
});
const RequestAdapterConfigurationSchema = z.object({
  bearerAuthTokenResponseHeader: z.string().optional()
});
const ClientP12ConfigurationSchema = z.object({
  path: z.string(),
  password: z.string().optional()
});
const APIClientConfigurationSchema = z.object({
  headers: z.record(z.string()).optional(),
  sessionConfiguration: SessionConfigurationSchema.optional(),
  retryPolicyConfiguration: RetryPolicyConfigurationSchema.optional(),
  requestAdapterConfiguration: RequestAdapterConfigurationSchema.optional(),
  clientP12Configuration: ClientP12ConfigurationSchema.optional()
});
const RequestOptionsSchema = z.object({
  headers: z.record(z.string()).optional(),
  body: z.union([z.record(z.unknown()), z.array(z.unknown()), z.string()]).optional(),
  timeoutInterval: z.number().optional(),
  retryPolicyConfiguration: RetryPolicyConfigurationSchema.optional()
});
const MultipartUploadConfigSchema = z.object({
  fileKey: z.string().optional(),
  data: z.record(z.string()).optional()
});
const UploadRequestOptionsSchema = RequestOptionsSchema.extend({
  skipBytes: z.number().optional(),
  method: z.string().optional(),
  multipart: MultipartUploadConfigSchema.optional()
});
const validateAPIClientConfiguration = config => {
  const result = APIClientConfigurationSchema.safeParse(config);
  if (!result.success) {
    console.warn(result.error); // eslint-disable-line no-console
  }
};
exports.validateAPIClientConfiguration = validateAPIClientConfiguration;
const validateRequestOptions = options => {
  if (options) {
    const result = RequestOptionsSchema.safeParse(options);
    if (!result.success) {
      console.warn(result.error); // eslint-disable-line no-console
    }
  }
};
exports.validateRequestOptions = validateRequestOptions;
const validateUploadRequestOptions = options => {
  if (options) {
    const result = UploadRequestOptionsSchema.safeParse(options);
    if (!result.success) {
      console.warn(result.error); // eslint-disable-line no-console
    }
  }
};
exports.validateUploadRequestOptions = validateUploadRequestOptions;
//# sourceMappingURL=schemas.js.map