"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INITIAL_VALUE = exports.INITIAL_SNAP_POINT = exports.INITIAL_POSITION = exports.INITIAL_HANDLE_HEIGHT = exports.INITIAL_CONTAINER_OFFSET = exports.INITIAL_CONTAINER_HEIGHT = exports.DEFAULT_OVER_DRAG_RESISTANCE_FACTOR = exports.DEFAULT_KEYBOARD_INPUT_MODE = exports.DEFAULT_KEYBOARD_BLUR_BEHAVIOR = exports.DEFAULT_KEYBOARD_BEHAVIOR = exports.DEFAULT_HANDLE_HEIGHT = exports.DEFAULT_ENABLE_PAN_DOWN_TO_CLOSE = exports.DEFAULT_ENABLE_OVER_DRAG = exports.DEFAULT_ENABLE_HANDLE_PANNING_GESTURE = exports.DEFAULT_ENABLE_CONTENT_PANNING_GESTURE = exports.DEFAULT_ENABLE_BLUR_KEYBOARD_ON_GESTURE = exports.DEFAULT_DYNAMIC_SIZING = exports.DEFAULT_ANIMATE_ON_MOUNT = exports.DEFAULT_ACCESSIBLE = exports.DEFAULT_ACCESSIBILITY_ROLE = exports.DEFAULT_ACCESSIBILITY_LABEL = void 0;
var _constants = require("../../constants");
// default values
const DEFAULT_HANDLE_HEIGHT = exports.DEFAULT_HANDLE_HEIGHT = 24;
const DEFAULT_OVER_DRAG_RESISTANCE_FACTOR = exports.DEFAULT_OVER_DRAG_RESISTANCE_FACTOR = 2.5;
const DEFAULT_ENABLE_CONTENT_PANNING_GESTURE = exports.DEFAULT_ENABLE_CONTENT_PANNING_GESTURE = true;
const DEFAULT_ENABLE_HANDLE_PANNING_GESTURE = exports.DEFAULT_ENABLE_HANDLE_PANNING_GESTURE = true;
const DEFAULT_ENABLE_OVER_DRAG = exports.DEFAULT_ENABLE_OVER_DRAG = true;
const DEFAULT_ENABLE_PAN_DOWN_TO_CLOSE = exports.DEFAULT_ENABLE_PAN_DOWN_TO_CLOSE = false;
const DEFAULT_ANIMATE_ON_MOUNT = exports.DEFAULT_ANIMATE_ON_MOUNT = true;
const DEFAULT_DYNAMIC_SIZING = exports.DEFAULT_DYNAMIC_SIZING = true;

// keyboard
const DEFAULT_KEYBOARD_BEHAVIOR = exports.DEFAULT_KEYBOARD_BEHAVIOR = _constants.KEYBOARD_BEHAVIOR.interactive;
const DEFAULT_KEYBOARD_BLUR_BEHAVIOR = exports.DEFAULT_KEYBOARD_BLUR_BEHAVIOR = _constants.KEYBOARD_BLUR_BEHAVIOR.none;
const DEFAULT_KEYBOARD_INPUT_MODE = exports.DEFAULT_KEYBOARD_INPUT_MODE = _constants.KEYBOARD_INPUT_MODE.adjustPan;
const DEFAULT_ENABLE_BLUR_KEYBOARD_ON_GESTURE = exports.DEFAULT_ENABLE_BLUR_KEYBOARD_ON_GESTURE = false;

// initial values
const INITIAL_VALUE = exports.INITIAL_VALUE = Number.NEGATIVE_INFINITY;
const INITIAL_SNAP_POINT = exports.INITIAL_SNAP_POINT = -999;
const INITIAL_CONTAINER_HEIGHT = exports.INITIAL_CONTAINER_HEIGHT = -999;
const INITIAL_CONTAINER_OFFSET = exports.INITIAL_CONTAINER_OFFSET = {
  top: 0,
  bottom: 0,
  left: 0,
  right: 0
};
const INITIAL_HANDLE_HEIGHT = exports.INITIAL_HANDLE_HEIGHT = -999;
const INITIAL_POSITION = exports.INITIAL_POSITION = _constants.SCREEN_HEIGHT;

// accessibility
const DEFAULT_ACCESSIBLE = exports.DEFAULT_ACCESSIBLE = true;
const DEFAULT_ACCESSIBILITY_LABEL = exports.DEFAULT_ACCESSIBILITY_LABEL = 'Bottom Sheet';
const DEFAULT_ACCESSIBILITY_ROLE = exports.DEFAULT_ACCESSIBILITY_ROLE = 'adjustable';
//# sourceMappingURL=constants.js.map