export interface IntlLocaleOptions {
    language?: string;
    script?: string;
    region?: string;
    calendar?: string;
    collation?: string;
    hourCycle?: 'h11' | 'h12' | 'h23' | 'h24';
    caseFirst?: 'upper' | 'lower' | 'false';
    numberingSystem?: string;
    numeric?: boolean;
    firstDayOfWeek?: string;
}
export interface IntlLocaleInternal extends IntlLocaleOptions {
    locale: string;
    initializedLocale: boolean;
}
export declare class Locale {
    constructor(tag: string | Locale, opts?: IntlLocaleOptions);
    /**
     * https://www.unicode.org/reports/tr35/#Likely_Subtags
     */
    maximize(): Locale;
    /**
     * https://www.unicode.org/reports/tr35/#Likely_Subtags
     */
    minimize(): Locale;
    toString(): string;
    get baseName(): string;
    get calendar(): string | undefined;
    get collation(): string | undefined;
    get caseFirst(): 'upper' | 'lower' | 'false' | undefined;
    get numeric(): boolean | undefined;
    get numberingSystem(): string | undefined;
    /**
     * https://tc39.es/proposal-intl-locale/#sec-Intl.Locale.prototype.language
     */
    get language(): string;
    /**
     * https://tc39.es/proposal-intl-locale/#sec-Intl.Locale.prototype.script
     */
    get script(): string | undefined;
    /**
     * https://tc39.es/proposal-intl-locale/#sec-Intl.Locale.prototype.region
     */
    get region(): string | undefined;
    get firstDayOfWeek(): string | undefined;
    get hourCycle(): 'h11' | 'h12' | 'h23' | 'h24' | undefined;
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getCalendars
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getCalendars
     */
    getCalendars(): string[];
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getCollations
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getCollations
     */
    getCollations(): string[];
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getHourCycles
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getHourCycles
     */
    getHourCycles(): string[];
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getNumberingSystems
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getNumberingSystems
     */
    getNumberingSystems(): string[];
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getTimeZones
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getTimeZones
     */
    getTimeZones(): string[] | undefined;
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getTextInfo
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getTextInfo
     */
    getTextInfo(): {
        direction: string;
    };
    /**
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getWeekInfo
     * https://tc39.es/proposal-intl-locale-info/#sec-Intl.Locale.prototype.getWeekInfo
     */
    getWeekInfo(): {
        firstDay: string;
        weekend: {
            start: string;
            end: string;
        };
        minimalDays: number;
    };
    static relevantExtensionKeys: readonly [
        'ca',
        'co',
        'hc',
        'kf',
        'kn',
        'nu',
        'fw'
    ];
    static readonly polyfilled = true;
}
export default Locale;
