// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import Svg, {G, Rect, Circle, Path, ClipPath, Defs} from 'react-native-svg';

export default function EmptyStateIcon() {
    return (
        <Svg
            width='196'
            height='121'
            viewBox='0 0 196 121'
            fill='none'
            testID='empty-state-icon'
        >
            <G clipPath='url(#clip0_4534_41619)'>
                <Rect
                    x='5.74512'
                    y='22.5'
                    width='181'
                    height='78'
                    rx='5.625'
                    fill='#1C58D9'
                    fillOpacity='0.12'
                />
                <Path
                    d='M14 11.5L19.5 17V71H40.5'
                    stroke='#BABEC9'
                    strokeLinecap='round'
                />
                <Circle
                    cx='2.5'
                    cy='2.5'
                    r='2.5'
                    transform='matrix(1 0 0 -1 10 12.5)'
                    fill='#3F4350'
                    fillOpacity='0.48'
                />
                <Path
                    d='M7 35.5L12.5 41V80H177.5V109'
                    stroke='#BABEC9'
                    strokeLinecap='round'
                />
                <Circle
                    cx='2.5'
                    cy='2.5'
                    r='2.5'
                    transform='matrix(1 0 0 -1 175 112.5)'
                    fill='#3F4350'
                    fillOpacity='0.48'
                />
                <Circle
                    cx='2.5'
                    cy='2.5'
                    r='2.5'
                    transform='matrix(1 0 0 -1 3 36.5)'
                    fill='#3F4350'
                    fillOpacity='0.48'
                />
                <Path
                    opacity='0.32'
                    d='M61.8756 22.5H129.615L133.745 115.5H57.7451L61.8756 22.5Z'
                    fill='#3F4350'
                    fillOpacity='0.24'
                />
                <Rect
                    opacity='0.32'
                    width='92'
                    height='5'
                    transform='matrix(1 0 0 -1 49.7451 120.5)'
                    fill='#3F4350'
                    fillOpacity='0.48'
                />
                <Rect
                    x='29.7451'
                    y='16.5'
                    width='131'
                    height='86'
                    rx='4'
                    fill='white'
                    stroke='#3F4350'
                    strokeWidth='4'
                />
                <Path
                    d='M60.0254 44.7423C64.5106 44.7423 68.1466 41.1063 68.1466 36.6211C68.1466 32.136 64.5106 28.5 60.0254 28.5C55.5403 28.5 51.9043 32.136 51.9043 36.6211C51.9043 41.1063 55.5403 44.7423 60.0254 44.7423Z'
                    fill='#3DB887'
                />
                <Path
                    d='M56.2031 36.2229L59.0191 39.0096L63.8465 34.2324'
                    stroke='white'
                    strokeWidth='1.19'
                    strokeLinecap='round'
                    strokeLinejoin='round'
                />
                <Path
                    d='M72.0527 32.9158H94.5334'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    d='M96.9434 32.9158H106.578'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    d='M108.984 32.9158H112.999'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    opacity='0.5'
                    d='M122.987 35.7261H72.0527V41.8017H122.987V35.7261Z'
                    fill='#3F4350'
                    fillOpacity='0.24'
                />
                <Path
                    d='M60.0254 68.0113C64.5106 68.0113 68.1466 64.3753 68.1466 59.8902C68.1466 55.405 64.5106 51.769 60.0254 51.769C55.5403 51.769 51.9043 55.405 51.9043 59.8902C51.9043 64.3753 55.5403 68.0113 60.0254 68.0113Z'
                    fill='#3DB887'
                />
                <Path
                    d='M56.2031 59.4919L59.0191 62.2786L63.8465 57.5015'
                    stroke='white'
                    strokeWidth='1.19'
                    strokeLinecap='round'
                    strokeLinejoin='round'
                />
                <Path
                    d='M72.0527 56.1848H94.5334'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    d='M96.9434 56.1848H106.578'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    d='M108.984 56.1848H112.999'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    opacity='0.5'
                    d='M138.987 58.9951H72.0527V65.0707H138.987V58.9951Z'
                    fill='#3F4350'
                    fillOpacity='0.24'
                />
                <Rect
                    x='110'
                    y='0.5'
                    width='83'
                    height='50'
                    rx='4'
                    fill='#28427B'
                />
                <Path
                    d='M152 10.5H166.481'
                    stroke='white'
                    strokeLinecap='round'
                />
                <Path
                    d='M152 16.5H175'
                    stroke='white'
                    strokeLinecap='round'
                />
                <Path
                    d='M152 22.5H182'
                    stroke='white'
                    strokeLinecap='round'
                />
                <Path
                    d='M152 28.5H182'
                    stroke='white'
                    strokeLinecap='round'
                />
                <Path
                    d='M168.891 10.5H178.525'
                    stroke='white'
                    strokeLinecap='round'
                />
                <Path
                    d='M180.932 10.5H183.946'
                    stroke='white'
                    strokeLinecap='round'
                />
                <Path
                    fillRule='evenodd'
                    clipRule='evenodd'
                    d='M127.509 7.4187H130.5L130.879 9.88061C131.795 10.0888 132.652 10.4503 133.423 10.9368L135.435 9.46111L137.55 11.5762L136.057 13.6123C136.521 14.3746 136.865 15.2186 137.061 16.1178L139.592 16.5072V19.4983L136.996 19.8976C136.779 20.7503 136.428 21.5495 135.968 22.2718L137.55 24.4292L135.435 26.5442L133.226 24.9246C132.521 25.3427 131.747 25.658 130.926 25.8498L130.505 28.5866H127.513L127.089 25.8268C126.282 25.6281 125.523 25.31 124.83 24.8922L122.577 26.5441L120.462 24.4291L122.097 22.1996C121.661 21.5008 121.328 20.7316 121.118 19.913L118.422 19.4982V16.5071L121.053 16.1023C121.243 15.2371 121.57 14.4232 122.01 13.6843L120.464 11.5762L122.579 9.46117L124.636 10.9695C125.391 10.4854 126.23 10.1216 127.126 9.90523L127.509 7.4187ZM133.041 17.8707C133.041 20.0721 131.256 21.8568 129.055 21.8568C126.853 21.8568 125.068 20.0721 125.068 17.8707C125.068 15.6692 126.853 13.8846 129.055 13.8846C131.256 13.8846 133.041 15.6692 133.041 17.8707Z'
                    fill='white'
                />
                <Path
                    fillRule='evenodd'
                    clipRule='evenodd'
                    d='M138.405 31.4482H140.038L140.245 32.7919C140.744 32.9054 141.212 33.1025 141.633 33.3678L142.73 32.563L143.885 33.7174L143.071 34.8275C143.325 35.2439 143.512 35.7051 143.619 36.1965L145 36.4089V38.0415L143.584 38.2593C143.466 38.7252 143.274 39.1619 143.022 39.5564L143.885 40.7329L142.73 41.8873L141.526 41.0039C141.141 41.2317 140.719 41.4035 140.271 41.5081L140.042 43.0022H138.409L138.177 41.496C137.737 41.3876 137.322 41.214 136.944 40.986L135.715 41.8875L134.56 40.733L135.452 39.5168C135.214 39.1352 135.032 38.7151 134.917 38.268L133.445 38.0415V36.4089L134.882 36.1879C134.986 35.7157 135.164 35.2715 135.404 34.8683L134.56 33.7175L135.715 32.563L136.837 33.3864C137.249 33.1222 137.707 32.9236 138.196 32.8055L138.405 31.4482ZM141.426 37.1531C141.426 38.3547 140.452 39.3288 139.25 39.3288C138.048 39.3288 137.074 38.3547 137.074 37.1531C137.074 35.9515 138.048 34.9774 139.25 34.9774C140.452 34.9774 141.426 35.9515 141.426 37.1531Z'
                    fill='white'
                />
                <Rect
                    x='54.5'
                    y='79.9824'
                    width='84'
                    height='11.0354'
                    fill='white'
                    stroke='#3F4350'
                />
                <Rect
                    opacity='0.3'
                    x='57.0098'
                    y='82.4912'
                    width='78.9823'
                    height='6.0177'
                    fill='#3F4350'
                    fillOpacity='0.24'
                />
                <Rect
                    x='57.0098'
                    y='82.4912'
                    width='52.6549'
                    height='6.0177'
                    fill='#3F4350'
                    fillOpacity='0.24'
                />
                <Path
                    d='M150 109H122.5'
                    stroke='#3F4350'
                    strokeLinecap='round'
                    strokeLinejoin='round'
                />
                <Path
                    d='M119 109H113'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
                <Path
                    d='M110 109H104'
                    stroke='#3F4350'
                    strokeLinecap='round'
                />
            </G>
            <Defs>
                <ClipPath id='clip0_4534_41619'>
                    <Rect
                        width='196'
                        height='120'
                        fill='white'
                        transform='translate(0 0.5)'
                    />
                </ClipPath>
            </Defs>
        </Svg>
    );
}
