// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import * as React from 'react';
import Svg, {Path} from 'react-native-svg';

type Props = {
    fillColor: string;
}

function SwipeLeftHand({fillColor, ...props}: Props) {
    return (
        <Svg
            width={55}
            height={48}
            viewBox='0 0 55 48'
            fill='none'
            {...props}
        >
            <Path
                opacity={0.5}
                d='M11.92 9h35.883v6H11.921v9L0 12 11.92 0v9z'
                fill={fillColor}
            />
            <Path
                d='M47.664 22.5a2.99 2.99 0 00-1.668.507A3.007 3.007 0 0043.164 21a2.99 2.99 0 00-1.668.507 3.007 3.007 0 00-2.832-2.007c-.546 0-1.06.147-1.5.404V15c0-1.655-1.346-3-3-3-1.655 0-3 1.345-3 3v17.536l-4.124-2.062A4.521 4.521 0 0025.03 30a2.87 2.87 0 00-2.865 2.874c0 .767.298 1.485.84 2.026l9.699 9.7a11.533 11.533 0 008.21 3.4c5.377 0 9.75-4.374 9.75-9.75V25.5c0-1.654-1.345-3-3-3zm1.5 15.75c0 4.55-3.703 8.25-8.252 8.25-2.701 0-5.24-1.052-7.147-2.962l-9.7-9.7c-.259-.256-.401-.6-.401-.973 0-.753.612-1.365 1.365-1.365.463 0 .925.11 1.34.317l5.21 2.603a.75.75 0 001.085-.67V15c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v14.25a.75.75 0 001.5 0V22.5c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v6.75a.75.75 0 001.5 0V24c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v5.25a.75.75 0 001.5 0V25.5c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v12.75z'
                fill={fillColor}
            />
            <Path
                d='M49.164 38.25c0 4.55-3.703 8.25-8.252 8.25-2.701 0-5.24-1.052-7.147-2.962l-9.7-9.7c-.259-.256-.401-.6-.401-.973 0-.753.612-1.365 1.365-1.365.463 0 .925.11 1.34.317l5.21 2.603a.75.75 0 001.085-.67V15c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v14.25a.75.75 0 001.5 0V22.5c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v6.75a.75.75 0 001.5 0V24c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v5.25a.75.75 0 001.5 0V25.5c0-.826.672-1.5 1.5-1.5s1.5.674 1.5 1.5v12.75z'
                fill={fillColor}
            />
        </Svg>
    );
}

export default SwipeLeftHand;

