// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import React from 'react';
import Svg, {Circle, ClipPath, Defs, G, Line, Path, Rect} from 'react-native-svg';

import {useTheme} from '@context/theme';

const DraftEmpty = () => {
    const theme = useTheme();

    return (
        <Svg
            width={142}
            height={80}
            viewBox='0 0 142 80'
            fill='none'
        >
            <G clipPath='url(#clip0_4212_90546)'>
                <Rect
                    x={15.0059}
                    y={15}
                    width={112}
                    height={44}
                    rx={3}
                    fill={theme.buttonBg}
                    fillOpacity={0.12}
                />
                <Path
                    d='M28.0059 34L28.0059 52L39.0059 52'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                    strokeLinejoin='round'
                />
                <Path
                    d='M28.0059 31L28.0059 26'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                    strokeLinejoin='round'
                />
                <Path
                    d='M28.0059 23L28.0059 21'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                    strokeLinejoin='round'
                />
                <Path
                    d='M54.6108 67.5638L41.0059 81V12C41.0059 10.8954 41.9013 10 43.0059 10H109.006C110.11 10 111.006 10.8954 111.006 12V64.9868C111.006 66.0914 110.11 66.9868 109.006 66.9868H56.0162C55.4901 66.9868 54.9851 67.1941 54.6108 67.5638Z'
                    fill='#28427B'
                />
                <Path
                    d='M49.6108 62.5638L36.0059 76V7C36.0059 5.89543 36.9013 5 38.0059 5H104.006C105.11 5 106.006 5.89543 106.006 7V59.9868C106.006 61.0914 105.11 61.9868 104.006 61.9868H51.0162C50.4901 61.9868 49.9851 62.1941 49.6108 62.5638Z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M49.2595 62.2081L36.5059 74.8035V7C36.5059 6.17157 37.1774 5.5 38.0059 5.5H104.006C104.834 5.5 105.506 6.17157 105.506 7V59.9868C105.506 60.8153 104.834 61.4868 104.006 61.4868H51.0162C50.3585 61.4868 49.7274 61.746 49.2595 62.2081Z'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                />
                <Circle
                    cx={54.0059}
                    cy={24}
                    r={9}
                    fill={theme.centerChannelColor}
                    fillOpacity={0.32}
                />
                <Path
                    d='M69.0059 20H85.0059'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                    strokeLinecap='round'
                />
                <Path
                    d='M46.0059 44H96.0059'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                    strokeLinecap='round'
                />
                <Path
                    d='M46.0059 51H68.0059'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                    strokeLinecap='round'
                />
                <Path
                    d='M69.0059 26H94.0059'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                    strokeLinecap='round'
                />
                <Path
                    d='M46.0059 38H63.0059'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                    strokeLinecap='round'
                />
                <Path
                    d='M67.0059 38H85.0059'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                    strokeLinecap='round'
                />
                <Rect
                    x={115.199}
                    y={45.0278}
                    width={12.4524}
                    height={6.22619}
                    transform='rotate(-135 115.199 45.0278)'
                    fill={theme.centerChannelBg}
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                />
                <Path
                    d='M117.952 42.2764L109.147 33.4712L113.787 28.8319C114.568 28.0508 115.834 28.0508 116.615 28.8319L122.592 34.8086C123.373 35.5897 123.373 36.856 122.592 37.637L117.952 42.2764Z'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.32}
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                />
                <Path
                    d='M89.3356 70.8933L80.5305 62.0882L106.946 35.6727L115.751 44.4778L89.3356 70.8933Z'
                    fill={theme.centerChannelBg}
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinejoin='round'
                />
                <Path
                    d='M73.1016 78.8725L80.5309 62.0876L89.3361 70.8928L73.1016 78.8725Z'
                    fill={theme.centerChannelBg}
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinejoin='round'
                />
                <Path
                    d='M78.3289 76.3964L75.4492 77.9756C74.5896 78.447 73.6355 77.5284 74.0739 76.6516L75.5773 73.6448L78.3289 76.3964Z'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.8}
                />
                <Line
                    x1={82.8065}
                    y1={64.4976}
                    x2={109.377}
                    y2={37.9268}
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.32}
                />
                <Line
                    x1={86.6825}
                    y1={68.3725}
                    x2={113.253}
                    y2={41.8017}
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.32}
                />
            </G>
            <Defs>
                <ClipPath id='clip0_4212_90546'>
                    <Rect
                        width={142}
                        height={80}
                        fill={theme.centerChannelBg}
                        transform='translate(0.00585938)'
                    />
                </ClipPath>
            </Defs>
        </Svg>
    );
};

export default DraftEmpty;
